/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.anti.replay.validator;

import online.inote.naruto.anti.replay.props.ReplayProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.exception.replay.ReplayException;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.DateTimeUtils;
import online.inote.naruto.utils.StringUtils;

public class AntiReplayValidator {
    public static AntiReplayWorker builder() {
        return new AntiReplayWorker();
    }

    public static class AntiReplayWorker
    implements AutoCloseable {
        private String nonce;
        private String methodName;
        private String url;
        private String targetUrl;
        private long timestamp;
        private Long version;

        public AntiReplayWorker nonce(String nonce) {
            Assert.notNull((Object)nonce, (String)"\u8bf7\u6c42\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            this.nonce = nonce;
            return this;
        }

        public AntiReplayWorker methodName(String methodName) {
            Assert.notNull((Object)methodName, (String)"\u8bf7\u6c42\u65b9\u6cd5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.methodName = methodName;
            return this;
        }

        public AntiReplayWorker url(String url) {
            Assert.notNull((Object)url, (String)"URL\u4e0d\u80fd\u4e3a\u7a7a");
            this.url = StringUtils.startAt((String)url, (CharSequence)"/");
            return this;
        }

        public AntiReplayWorker targetUrl(String targetUrl) {
            Assert.notNull((Object)targetUrl, (String)"targetUrl\u4e0d\u80fd\u4e3a\u7a7a");
            this.targetUrl = StringUtils.startAt((String)targetUrl, (CharSequence)"/");
            return this;
        }

        public AntiReplayWorker timestamp(Long timestamp) {
            Assert.notNull((Object)timestamp, (String)"\u8bf7\u6c42\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            this.timestamp = timestamp;
            return this;
        }

        public void execute() {
            if (!StringUtils.equals((CharSequence)this.url, (CharSequence)this.targetUrl)) {
                throw new ReplayException("\u8bf7URL\u4e0e\u5b9e\u9645\u8bf7\u6c42\u8def\u5f84\u4e0d\u7b26");
            }
            ReplayProperties props = ReplayProperties.props();
            if (DateTimeUtils.betweenNowSeconds((Long)this.timestamp) > props.getRequest().getExpireTime()) {
                throw new ReplayException("\u8bf7\u6c42\u5df2\u8fc7\u671f");
            }
            String key = this.genKey();
            this.version = CacheSupport.increment((String)key);
            if (props.getCache().getLockHoldTime() > 0L) {
                CacheSupport.expire((String)key, (long)props.getCache().getLockHoldTime());
            }
            if (this.version > 1L) {
                throw new ReplayException("\u8bf7\u6c42\u6b63\u5728\u6267\u884c,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
        }

        private String genKey() {
            return ReplayProperties.props().getCache().getCacheKeyPrefix() + this.methodName + ":" + this.nonce;
        }

        @Override
        public void close() {
            if (this.version == 1L) {
                CacheSupport.delete((String)this.genKey());
            }
        }
    }
}

