/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.anti.replay.validator;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import online.inote.naruto.anti.replay.props.ReplayProperties;
import online.inote.naruto.exception.replay.DataSignatureException;
import online.inote.naruto.utils.ConvertUtils;
import online.inote.naruto.utils.MdFiveUtils;
import online.inote.naruto.utils.StringUtils;
import org.springframework.util.Assert;

public class SignatureValidator {
    public static SignatureWorker builder() {
        return new SignatureWorker();
    }

    public static class SignatureWorker {
        private String nonce;
        private Long timestamp;
        private String url;
        private String token;
        private Object[] requestBody;
        private String params;
        private String signature;

        public SignatureWorker nonce(String nonce) {
            Assert.notNull((Object)nonce, (String)"\u8bf7\u6c42\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            this.nonce = nonce;
            return this;
        }

        public SignatureWorker timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SignatureWorker url(String url) {
            Assert.notNull((Object)url, (String)"\u8bf7\u6c42URL\u4e0d\u80fd\u4e3a\u7a7a");
            this.url = url;
            return this;
        }

        public SignatureWorker token(String token) {
            this.token = token;
            return this;
        }

        public SignatureWorker requestBody(Object[] requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public SignatureWorker params(Map<String, String[]> parameterMap) {
            this.params = JSON.toJSONString(parameterMap);
            return this;
        }

        public SignatureWorker signature(String signature) {
            Assert.notNull((Object)signature, (String)"\u7b7e\u540d\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a");
            this.signature = signature;
            return this;
        }

        public SignatureWorker data(HttpServletRequest request) {
            ReplayProperties.HeaderKey headerKey = ReplayProperties.props().getHeaderKey();
            return this.nonce(request.getHeader(headerKey.getNonce())).timestamp(ConvertUtils.StringToLong((String)request.getHeader(headerKey.getTimestamp()))).url(request.getHeader(headerKey.getUrl())).token(request.getHeader(headerKey.getToken())).params(request.getParameterMap()).signature(request.getHeader(headerKey.getSignature()));
        }

        public void execute() {
            String digest = MdFiveUtils.digest((String)this.nonce, (String)this.url, (Long)this.timestamp, (String)this.token, (String)this.params, (Object[])this.requestBody);
            if (!StringUtils.equals((CharSequence)this.signature, (CharSequence)digest)) {
                throw new DataSignatureException("\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
        }
    }
}

