/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.common.configure;

import io.jsonwebtoken.Claims;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import online.inote.naruto.api.access.admin.common.props.ApiAdminProperties;
import online.inote.naruto.api.access.jwt.JwtHelper;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final String HEADER_TOKEN_KEY = "naruto-token";
    @Autowired
    private ApiAdminProperties props;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            String token = request.getHeader(HEADER_TOKEN_KEY);
            if (StringUtils.isBlank((CharSequence)token)) {
                return false;
            }
            return this.checkToken(token);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String token = request.getHeader(HEADER_TOKEN_KEY);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            String id = ((Claims)JwtHelper.getClaims((String)token).getBody()).getId();
            CacheSupport.expire((String)(this.props.getCache().getCacheKeyPrefix() + id), (long)1800L);
        }
    }

    private boolean checkToken(String token) {
        String id = ((Claims)JwtHelper.getClaims((String)token).getBody()).getId();
        String cacheToken = CacheSupport.get((String)(this.props.getCache().getCacheKeyPrefix() + id));
        return StringUtils.equals((CharSequence)token, (CharSequence)cacheToken);
    }
}

