/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.common.configure;

import online.inote.naruto.api.access.admin.common.annotation.Web;
import online.inote.naruto.api.access.admin.common.configure.LoginInterceptor;
import online.inote.naruto.api.access.admin.common.props.ApiAdminProperties;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={ApiAdminProperties.class})
@ComponentScan(value={"online.inote.naruto.api.access.admin"})
@EntityScan(value={"online.inote.naruto.api.access.admin.modules.*.entity"})
@EnableJpaRepositories(value={"online.inote.naruto.api.access.admin.modules.*.repository"})
public class NarutoApiAccessAdminSpringConfiguration
implements WebMvcConfigurer {
    private static final String LOGIN_URL = "user/login";
    private final ApiAdminProperties props;

    NarutoApiAccessAdminSpringConfiguration(ApiAdminProperties props) {
        this.props = props;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String baseUrl = StringUtils.trimTrailingCharacter((String)this.props.getApi().getContextPath(), (char)'/');
        registry.addResourceHandler(new String[]{baseUrl + "/naruto-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/naruto-ui/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController(this.props.getApi().getContextPath() + "/naruto-ui/").setViewName("forward:" + this.props.getApi().getContextPath() + "/naruto-ui/index.html");
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor()).addPathPatterns(new String[]{this.props.getApi().getContextPath() + "**"}).excludePathPatterns(new String[]{this.props.getApi().getContextPath() + LOGIN_URL});
    }

    @Bean
    LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Configuration
    class NarutoSecurityWebPathMatchConfiguration
    implements WebMvcConfigurer {
        NarutoSecurityWebPathMatchConfiguration() {
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            configurer.addPathPrefix(NarutoApiAccessAdminSpringConfiguration.this.props.getApi().getContextPath(), c -> c.isAnnotationPresent(Web.class));
        }
    }
}

