/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.common.configure;

import online.inote.naruto.api.access.admin.common.annotation.Web;
import online.inote.naruto.api.access.admin.common.configure.LoginInterceptor;
import online.inote.naruto.api.access.admin.common.props.ApiAdminProperties;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={ApiAdminProperties.class})
@ComponentScan(value={"online.inote.naruto.api.access.admin"})
@EntityScan(value={"online.inote.naruto.api.access.admin.modules.*.entity"})
@EnableJpaRepositories(value={"online.inote.naruto.api.access.admin.modules.*.repository"})
public class NarutoApiAccessAdminSpringConfiguration
implements WebMvcConfigurer {
    private static final String LOGIN_URL = "/user/login";
    private final String baseUrl;

    NarutoApiAccessAdminSpringConfiguration(ApiAdminProperties props) {
        this.baseUrl = StringUtils.trimTrailingCharacter((String)props.getApi().getContextPath(), (char)'/') + "/naruto-ui/";
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.baseUrl + "**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/naruto-ui/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController(this.baseUrl).setViewName("forward:" + this.baseUrl + "/index.html");
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor()).addPathPatterns(new String[]{this.baseUrl + "/**"}).excludePathPatterns(new String[]{this.baseUrl + LOGIN_URL});
    }

    @Bean
    LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Configuration
    class NarutoSecurityWebPathMatchConfiguration
    implements WebMvcConfigurer {
        NarutoSecurityWebPathMatchConfiguration() {
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            configurer.addPathPrefix(NarutoApiAccessAdminSpringConfiguration.this.baseUrl, c -> c.isAnnotationPresent(Web.class));
        }
    }
}

