/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.controller;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import online.inote.naruto.api.access.admin.modules.base.controller.BaseController;
import online.inote.naruto.api.access.admin.modules.system.entity.ApiEntity;
import online.inote.naruto.api.access.admin.modules.system.entity.SystemEntity;
import online.inote.naruto.api.access.admin.modules.system.service.ApiService;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.utils.Page;
import online.inote.naruto.utils.ResultFactory;
import online.inote.naruto.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api"})
public class ApiController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ApiService apiService;
    private final ApiAccessProperties apiProps;

    public ApiController(ApiService apiService, ApiAccessProperties apiProps) {
        this.apiService = apiService;
        this.apiProps = apiProps;
    }

    @PostMapping(value={"save"})
    public ResultFactory<Object> save(@Valid @RequestBody ApiEntity apiEntity, BindingResult result) {
        if (result.hasErrors()) {
            return ResultFactory.fail((String)StringUtils.join((Object[])new List[]{result.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList())}));
        }
        try {
            this.apiService.save(apiEntity);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                this.logger.error("API\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                return ResultFactory.fail((String)"API\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25");
            }
            this.logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return ResultFactory.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return ResultFactory.success();
    }

    @GetMapping(value={"details/{id}"})
    public ResultFactory<Object> details(@PathVariable String id) {
        Optional<ApiEntity> optional = this.apiService.details(id);
        if (!optional.isPresent()) {
            return ResultFactory.fail((String)"\u672a\u67e5\u8be2\u5230\u6539\u63a5\u53e3\u4fe1\u606f");
        }
        ApiEntity apiEntity = optional.get();
        apiEntity.setAuthSystemNumber(CacheSupport.count((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(id)));
        return ResultFactory.success((Object)apiEntity);
    }

    @PostMapping(value={"getPage"})
    public ResultFactory<Page<ApiEntity>> getPage(@RequestBody Page<ApiEntity> page) {
        this.apiService.getPage(page);
        return ResultFactory.success(page);
    }

    @PostMapping(value={"enable"})
    public ResultFactory<SystemEntity> enable(@RequestBody ApiEntity api) {
        if (StringUtils.isBlank((CharSequence)api.getId()) || Objects.isNull(api.getEnable())) {
            return ResultFactory.create((ResultFactory.ResultEnum)ResultFactory.ResultEnum.PARAM_REQUIRED);
        }
        Optional<ApiEntity> optional = this.apiService.details(api.getId());
        if (!optional.isPresent()) {
            return ResultFactory.fail((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u4e8e\u7684API\u4fe1\u606f");
        }
        ApiEntity existsApiInfo = optional.get();
        existsApiInfo.setEnable(api.getEnable());
        this.apiService.save(existsApiInfo);
        return ResultFactory.success();
    }
}

