/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.controller;

import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import online.inote.naruto.api.access.admin.modules.base.controller.BaseController;
import online.inote.naruto.api.access.admin.modules.system.entity.AuthInterfaceEntity;
import online.inote.naruto.api.access.admin.modules.system.service.AuthInterfaceService;
import online.inote.naruto.utils.ResultFactory;
import online.inote.naruto.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"authInterface"})
public class AuthInterfaceController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AuthInterfaceService authInterfaceService;

    public AuthInterfaceController(AuthInterfaceService authInterfaceService) {
        this.authInterfaceService = authInterfaceService;
    }

    @PostMapping(value={"enable"})
    public ResultFactory<Object> enable(@RequestBody @Valid AuthInterfaceEntity aie, BindingResult result) {
        if (result.hasErrors()) {
            return ResultFactory.fail((String)StringUtils.join((Object[])new List[]{result.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList())}));
        }
        try {
            if (aie.getEnable().booleanValue()) {
                this.authInterfaceService.save(aie);
            } else {
                this.authInterfaceService.delete(aie);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6388\u6743\u5931\u8d25", (Throwable)e);
            return ResultFactory.fail((String)"\u6388\u6743\u5931\u8d25");
        }
        return ResultFactory.success();
    }
}

