/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import online.inote.naruto.api.access.admin.modules.system.entity.ManagerEntity;
import online.inote.naruto.api.access.admin.modules.system.entity.SystemEntity;
import online.inote.naruto.api.access.admin.modules.system.repository.ManagerRepository;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.exception.NormalOperationException;
import online.inote.naruto.utils.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class ManagerService {
    private final ManagerRepository repository;
    private final ApiAccessProperties apiProps;

    public ManagerService(ManagerRepository repository, ApiAccessProperties apiProps) {
        this.repository = repository;
        this.apiProps = apiProps;
    }

    public ManagerEntity getBySystemId(String systemId) {
        String managerInfo = CacheSupport.get((String)this.apiProps.getCache().initManagerCacheKey(systemId));
        if (StringUtils.isBlank((CharSequence)managerInfo) && this.apiProps.getDatabase().getEnable().booleanValue()) {
            return this.repository.findBySystemId(systemId);
        }
        if (StringUtils.isBlank((CharSequence)managerInfo)) {
            return null;
        }
        return (ManagerEntity)JSON.parseObject((String)managerInfo, ManagerEntity.class);
    }

    public void save(SystemEntity system) {
        ManagerEntity manager = system.getManager();
        manager.setSystemId(system.getId());
        if (StringUtils.isBlank((CharSequence)manager.getId())) {
            manager.setId(UUID.randomUUID().toString());
        }
        manager.genSignatureDigest();
        if (this.apiProps.getDatabase().getEnable().booleanValue()) {
            this.repository.save(manager);
        }
        CacheSupport.cache((String)this.apiProps.getCache().initManagerCacheKey(manager.getId()), (String)JSON.toJSONString((Object)manager));
    }

    public List<ManagerEntity> getManagerBySystemIdList(List<String> systemIdList) {
        List<ManagerEntity> managerEntities = this.getCacheManagerBySystemIdList(systemIdList);
        if (!CollectionUtils.isEmpty(managerEntities)) {
            List<ManagerEntity> dbManagerEntities;
            List cacheSystemIdList = managerEntities.stream().map(ManagerEntity::getSystemId).collect(Collectors.toList());
            boolean result = systemIdList.removeAll(cacheSystemIdList);
            if (result) {
                throw new NormalOperationException("\u7f13\u5b58ID\u5220\u9664\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty(systemIdList) && !CollectionUtils.isEmpty(dbManagerEntities = this.repository.findBySystemIdIn(systemIdList))) {
                managerEntities.addAll(dbManagerEntities);
            }
        } else {
            managerEntities = this.repository.findBySystemIdIn(systemIdList);
        }
        return managerEntities;
    }

    private List<ManagerEntity> getCacheManagerBySystemIdList(List<String> systemIdList) {
        Set managerSet = systemIdList.stream().map(id -> (ManagerEntity)JSON.parseObject((String)CacheSupport.get((String)this.apiProps.getCache().initManagerCacheKey(id)), ManagerEntity.class)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(managerSet)) {
            managerSet.remove(null);
        }
        return new ArrayList<ManagerEntity>(managerSet);
    }
}

