/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.common.configure;

import io.jsonwebtoken.Claims;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import online.inote.naruto.api.access.admin.common.props.ApiAdminProperties;
import online.inote.naruto.api.access.jwt.JwtHelper;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.utils.ResultFactory;
import online.inote.naruto.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LogManager.getLogger(LoginInterceptor.class);
    private static final String HEADER_TOKEN_KEY = "naruto-token";
    @Autowired
    private ApiAdminProperties props;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            String token = request.getHeader(HEADER_TOKEN_KEY);
            if (StringUtils.isBlank((CharSequence)token)) {
                log.info("\u8bf7\u6c42\u65e0token\u4fe1\u606f\uff0c\u7981\u6b62\u8bbf\u95ee");
                this.returnError(response, (ResultFactory<Object>)ResultFactory.fail((String)"\u8bf7\u6c42\u65e0token\u4fe1\u606f\uff0c\u7981\u6b62\u8bbf\u95ee"));
                return false;
            }
            return this.checkToken(token);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String token = request.getHeader(HEADER_TOKEN_KEY);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            String id = ((Claims)JwtHelper.getClaims((String)token).getBody()).getId();
            CacheSupport.expire((String)(this.props.getCache().getCacheKeyPrefix() + id), (long)1800L);
        }
    }

    private boolean checkToken(String token) {
        String id = ((Claims)JwtHelper.getClaims((String)token).getBody()).getId();
        String cacheToken = CacheSupport.get((String)(this.props.getCache().getCacheKeyPrefix() + id));
        return StringUtils.equals((CharSequence)token, (CharSequence)cacheToken);
    }

    private void returnError(HttpServletResponse response, ResultFactory<Object> result) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        response.setContentType("application/json");
        try {
            response.getWriter().print(result.toJson());
        }
        catch (IOException e) {
            log.error("response error", (Throwable)e);
        }
    }
}

