/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.service;

import java.util.List;
import online.inote.naruto.api.access.admin.modules.system.entity.AuthInterfaceEntity;
import online.inote.naruto.api.access.admin.modules.system.repository.AuthInterfaceRepository;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.DateTimeUtils;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class AuthInterfaceService {
    private final ApiAccessProperties apiProps;
    private final AuthInterfaceRepository repository;

    public AuthInterfaceService(ApiAccessProperties apiProps, AuthInterfaceRepository repository) {
        this.apiProps = apiProps;
        this.repository = repository;
    }

    public void save(AuthInterfaceEntity aie) {
        aie.setCreateTime(DateTimeUtils.getNow());
        aie.genSignatureDigest();
        if (this.apiProps.getDatabase().getEnable().booleanValue()) {
            List<AuthInterfaceEntity> authEntities = this.repository.findAllBySystemIdAndApiId(aie.getSystemId(), aie.getApiId());
            if (CollectionUtils.isEmpty(authEntities)) {
                this.repository.save(aie);
            }
            CacheSupport.addSet((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(aie.getSystemId()), (String[])new String[]{aie.getClassMethod()});
            CacheSupport.addSet((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(aie.getApiId()), (String[])new String[]{aie.getSystemId()});
        }
    }

    public void delete(AuthInterfaceEntity aie) {
        if (this.apiProps.getDatabase().getEnable().booleanValue()) {
            this.repository.deleteBySystemIdAndApiId(aie.getSystemId(), aie.getApiId());
        }
        CacheSupport.remove((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(aie.getSystemId()), (String[])new String[]{aie.getClassMethod()});
        CacheSupport.remove((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(aie.getApiId()), (String[])new String[]{aie.getSystemId()});
    }

    public List<AuthInterfaceEntity> findBySystemId(String systemId) {
        Assert.notBlank((String)systemId, (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
        Example example = Example.of((Object)AuthInterfaceEntity.builder().systemId(systemId).build());
        List authInterfaceEntities = this.repository.findAll(example);
        return authInterfaceEntities;
    }
}

