/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.controller;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import online.inote.naruto.api.access.admin.modules.base.controller.BaseController;
import online.inote.naruto.api.access.admin.modules.system.entity.SystemEntity;
import online.inote.naruto.api.access.admin.modules.system.service.SystemService;
import online.inote.naruto.utils.Page;
import online.inote.naruto.utils.ResultFactory;
import online.inote.naruto.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"system"})
public class SystemController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SystemService systemService;

    public SystemController(SystemService systemService) {
        this.systemService = systemService;
    }

    @PostMapping(value={"getPage"})
    public ResultFactory<Page<SystemEntity>> getPage(@RequestBody Page<SystemEntity> page) {
        this.systemService.getPage(page);
        return ResultFactory.success(page);
    }

    @PostMapping(value={"save"})
    public ResultFactory<String> save(@RequestBody @Valid SystemEntity system, BindingResult result) {
        if (result.hasErrors()) {
            return ResultFactory.fail((String)StringUtils.join((Object[])new List[]{result.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList())}));
        }
        try {
            return this.systemService.save(system, true);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return ResultFactory.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @PostMapping(value={"enable"})
    public ResultFactory<SystemEntity> enable(@RequestBody SystemEntity system) {
        if (StringUtils.isBlank((CharSequence)system.getId()) || Objects.isNull(system.getEnable())) {
            return ResultFactory.create((ResultFactory.ResultEnum)ResultFactory.ResultEnum.PARAM_REQUIRED);
        }
        SystemEntity existsSystemInfo = this.systemService.details(system.getId());
        if (Objects.isNull(existsSystemInfo)) {
            return ResultFactory.fail((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u4e8e\u7684\u7cfb\u7edf\u4fe1\u606f");
        }
        existsSystemInfo.setEnable(system.getEnable());
        this.systemService.save(existsSystemInfo, false);
        return ResultFactory.success();
    }

    @GetMapping(value={"details/{id}"})
    public ResultFactory<SystemEntity> details(@PathVariable String id) {
        return ResultFactory.success((Object)this.systemService.details(id));
    }
}

