/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.login.controller;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import online.inote.naruto.api.access.admin.common.props.ApiAdminProperties;
import online.inote.naruto.api.access.admin.modules.base.controller.BaseController;
import online.inote.naruto.api.access.admin.modules.login.entity.UserEntity;
import online.inote.naruto.api.access.jwt.JwtHelper;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.common.utils.response.ExtendResponse;
import online.inote.naruto.common.utils.response.Response;
import online.inote.naruto.utils.DateTimeUtils;
import online.inote.naruto.utils.StringUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user"})
public class UserController
extends BaseController {
    private final ApiAdminProperties props;

    public UserController(ApiAdminProperties props) {
        this.props = props;
    }

    @PostMapping(value={"login"})
    public Response<String> login(@RequestBody UserEntity user) {
        if (StringUtils.isBlank((CharSequence)user.getUsername()) || StringUtils.isBlank((CharSequence)user.getPassword())) {
            return ExtendResponse.fail((String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String password = user.getPassword();
        ApiAdminProperties.Administrator administrator = this.props.getAdministrator();
        if (!StringUtils.equals((CharSequence)user.getUsername(), (CharSequence)administrator.getUsername()) || !StringUtils.equals((CharSequence)password, (CharSequence)administrator.getPassword())) {
            return ExtendResponse.fail((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        user.setSecurityKey(UUID.randomUUID().toString());
        user.setPassword(null);
        String token = JwtHelper.genToken((String)user.getId(), (String)user.getUsername(), (Map)JSON.parseObject((String)JSON.toJSONString((Object)user)), (Date)DateTimeUtils.getNow());
        CacheSupport.cache((String)(this.props.getCache().getCacheKeyPrefix() + user.getId()), (String)token, (long)1800L);
        return ExtendResponse.success((Object)token);
    }

    @GetMapping(value={"info"})
    public Response<UserEntity> info(@Param(value="token") String token) {
        Jws claims = JwtHelper.getClaims((String)token);
        return ExtendResponse.success((Object)UserEntity.builder().username((String)((Claims)claims.getBody()).get((Object)"username")).build());
    }

    @PostMapping(value={"logout"})
    public Response<Object> logout(@RequestHeader(value="naruto-token") String token) {
        String cacheTokenId = ((Claims)JwtHelper.getClaims((String)token).getBody()).getId();
        CacheSupport.delete((String)(this.props.getCache().getCacheKeyPrefix() + cacheTokenId));
        return ExtendResponse.success();
    }
}

