/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.service;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import online.inote.naruto.api.access.admin.modules.system.entity.ApiEntity;
import online.inote.naruto.api.access.admin.modules.system.entity.AuthInterfaceEntity;
import online.inote.naruto.api.access.admin.modules.system.entity.SystemEntity;
import online.inote.naruto.api.access.admin.modules.system.repository.ApiRepository;
import online.inote.naruto.api.access.admin.modules.system.service.AuthInterfaceService;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.DateTimeUtils;
import online.inote.naruto.utils.StringUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class ApiService {
    private final ApiRepository repository;
    private final ApiAccessProperties apiProps;
    private final AuthInterfaceService authInterfaceService;

    public ApiService(ApiRepository repository, ApiAccessProperties apiProps, AuthInterfaceService authInterfaceService) {
        this.repository = repository;
        this.apiProps = apiProps;
        this.authInterfaceService = authInterfaceService;
    }

    public void save(ApiEntity api) {
        List<ApiEntity> apiEntities;
        if (StringUtils.isBlank((CharSequence)api.getId())) {
            api.setId(UUID.randomUUID().toString());
            api.setCreateTime(DateTimeUtils.getNow());
        }
        api.genSignatureDigest();
        if (this.apiProps.getDatabase().getEnable().booleanValue() && CollectionUtils.isEmpty(apiEntities = this.repository.findAllByTypeAndMethod(api.getType(), api.getMethod()))) {
            this.repository.save(api);
        }
        CacheSupport.cache((String)this.apiProps.getCache().initInterfaceInfoCacheKey(api.getId()), (String)JSON.toJSONString((Object)api));
    }

    public Optional<ApiEntity> details(String id) {
        return this.repository.findById(id);
    }

    public void getPage(online.inote.naruto.utils.Page<ApiEntity> page) {
        ApiEntity params = (ApiEntity)page.getSearchParams();
        Example example = Objects.nonNull(params) ? Example.of((Object)page.getSearchParams()) : Example.of((Object)new ApiEntity());
        Sort sort = Sort.by((String[])new String[]{"createTime"}).descending();
        PageRequest request = PageRequest.of((int)page.getEsPage(), (int)page.getRows(), (Sort)sort);
        Page resultPage = this.repository.findAll(example, (Pageable)request);
        page.setRecords(Long.valueOf(resultPage.getTotalElements()));
        page.setDataList(resultPage.getContent());
        if (CollectionUtils.isEmpty((Collection)page.getDataList())) {
            return;
        }
        page.getDataList().forEach(api -> {
            api.setAuthSystemNumber(CacheSupport.count((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(api.getId())));
            if (StringUtils.isNotBlank((CharSequence)params.getSystemId())) {
                api.setIsAuth(CacheSupport.isMember((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(api.getId()), (String)params.getSystemId()));
            }
        });
    }

    public void enableSystemCacheHandle(SystemEntity system) {
        Assert.notBlank((String)system.getId(), (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
        if (system.getEnable().booleanValue()) {
            List interfaceIdList;
            List apiEntities;
            List<AuthInterfaceEntity> aieEntities = this.authInterfaceService.findBySystemId(system.getId());
            if (!CollectionUtils.isEmpty(aieEntities) && !CollectionUtils.isEmpty((Collection)(apiEntities = this.repository.findAllById(interfaceIdList = aieEntities.stream().map(AuthInterfaceEntity::getApiId).collect(Collectors.toList()))))) {
                Set methodSet = apiEntities.stream().map(ApiEntity::getClassMethod).collect(Collectors.toSet());
                CacheSupport.addSet((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(system.getId()), methodSet);
            }
        } else {
            CacheSupport.delete((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(system.getId()));
        }
    }
}

