/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.admin.modules.system.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import online.inote.naruto.api.access.admin.modules.system.entity.ManagerEntity;
import online.inote.naruto.api.access.admin.modules.system.entity.SystemEntity;
import online.inote.naruto.api.access.admin.modules.system.repository.SystemRepository;
import online.inote.naruto.api.access.admin.modules.system.service.ManagerService;
import online.inote.naruto.api.access.jwt.JwtHelper;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.common.utils.response.ExtendResponse;
import online.inote.naruto.common.utils.response.Response;
import online.inote.naruto.utils.DateTimeUtils;
import online.inote.naruto.utils.StringUtils;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class SystemService {
    private final ApiAccessProperties apiProps;
    private final SystemRepository repository;
    private final ManagerService managerService;

    public SystemService(ApiAccessProperties apiProps, SystemRepository repository, ManagerService managerService) {
        this.apiProps = apiProps;
        this.repository = repository;
        this.managerService = managerService;
    }

    public Response<String> save(SystemEntity system, boolean isSaveManager) {
        if (Objects.isNull(system.getCreateTime())) {
            system.setCreateTime(DateTimeUtils.getNow());
        }
        system.genSignatureDigest();
        if (this.apiProps.getDatabase().getEnable().booleanValue()) {
            this.repository.save(system);
        }
        if (isSaveManager) {
            this.managerService.save(system);
        }
        this.enableSystemCacheHandle(system);
        return ExtendResponse.success();
    }

    private void enableSystemCacheHandle(SystemEntity system) {
        if (system.getEnable().booleanValue()) {
            String token = JwtHelper.genToken((String)system.getId(), (String)system.getName(), this.initGenTokenMap(system), (Date)system.getCreateTime());
            if (Objects.isNull(system.getExpireTime())) {
                CacheSupport.cache((String)this.apiProps.getCache().initSystemTokenCacheKey(system.getId()), (String)token);
            } else {
                CacheSupport.cache((String)this.apiProps.getCache().initSystemTokenCacheKey(system.getId()), (String)token, (long)DateTimeUtils.afterNowSeconds((Date)system.getExpireTime()));
            }
        } else {
            CacheSupport.delete((String)this.apiProps.getCache().initSystemTokenCacheKey(system.getId()));
        }
    }

    public SystemEntity details(String id) {
        Optional<SystemEntity> optional = this.info(id);
        if (!optional.isPresent()) {
            return null;
        }
        SystemEntity system = optional.get();
        system.setToken(JwtHelper.genToken((String)system.getId(), (String)system.getName(), this.initGenTokenMap(system), (Date)system.getCreateTime()));
        system.setManager(this.managerService.getBySystemId(system.getId()));
        system.setAuthInterfaceNumber(CacheSupport.count((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(system.getId())));
        return system;
    }

    private Map<String, Object> initGenTokenMap(SystemEntity system) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("englishName", system.getEnglishName());
        return paramMap;
    }

    public Optional<SystemEntity> info(String id) {
        return this.repository.findById(id);
    }

    public void getPage(online.inote.naruto.utils.Page<SystemEntity> page) {
        Example example = Objects.nonNull(page.getSearchParams()) ? Example.of((Object)page.getSearchParams()) : Example.of((Object)new SystemEntity());
        Sort sort = Sort.by((String[])new String[]{"createTime"}).descending();
        PageRequest request = PageRequest.of((int)page.getEsPage(), (int)page.getRows(), (Sort)sort);
        Page resultPage = this.repository.findAll(example, (Pageable)request);
        page.setRecords(Long.valueOf(resultPage.getTotalElements()));
        page.setDataList(resultPage.getContent());
        if (CollectionUtils.isEmpty((Collection)page.getDataList())) {
            return;
        }
        List<String> idList = page.getDataList().stream().map(SystemEntity::getId).collect(Collectors.toList());
        List<ManagerEntity> managerList = this.managerService.getManagerBySystemIdList(idList);
        Map<String, ManagerEntity> managerMap = managerList.stream().collect(Collectors.toMap(ManagerEntity::getSystemId, manager -> manager));
        page.getDataList().forEach(system -> {
            system.setManager((ManagerEntity)managerMap.get(system.getId()));
            system.setAuthInterfaceNumber(CacheSupport.count((String)this.apiProps.getCache().initSystemAuthInterfacePathCacheKey(system.getId())));
            if (StringUtils.isNotBlank((CharSequence)((SystemEntity)page.getSearchParams()).getApiId())) {
                system.setIsAuth(CacheSupport.isMember((String)this.apiProps.getCache().initInterfaceAuthSystemCacheKey(((SystemEntity)page.getSearchParams()).getApiId()), (String)system.getId()));
            }
        });
    }
}

