/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.api.access.props;

import online.inote.naruto.common.utils.bean.BeanFactory;
import online.inote.naruto.utils.Assert;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="naruto.security.api.access")
public class ApiAccessProperties {
    private Cache cache = new Cache();
    private Database database = new Database();
    private HeaderKey headerKey = new HeaderKey();
    private Token token = new Token();

    public static ApiAccessProperties props() {
        return (ApiAccessProperties)BeanFactory.getBean(ApiAccessProperties.class);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Database getDatabase() {
        return this.database;
    }

    public HeaderKey getHeaderKey() {
        return this.headerKey;
    }

    public Token getToken() {
        return this.token;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setHeaderKey(HeaderKey headerKey) {
        this.headerKey = headerKey;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiAccessProperties)) {
            return false;
        }
        ApiAccessProperties other = (ApiAccessProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        Database this$database = this.getDatabase();
        Database other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        HeaderKey this$headerKey = this.getHeaderKey();
        HeaderKey other$headerKey = other.getHeaderKey();
        if (this$headerKey == null ? other$headerKey != null : !((Object)this$headerKey).equals(other$headerKey)) {
            return false;
        }
        Token this$token = this.getToken();
        Token other$token = other.getToken();
        return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiAccessProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        Database $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        HeaderKey $headerKey = this.getHeaderKey();
        result = result * 59 + ($headerKey == null ? 43 : ((Object)$headerKey).hashCode());
        Token $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        return result;
    }

    public String toString() {
        return "ApiAccessProperties(cache=" + this.getCache() + ", database=" + this.getDatabase() + ", headerKey=" + this.getHeaderKey() + ", token=" + this.getToken() + ")";
    }

    public static class Token {
        private String issuer = "NARUTO_SECURITY";
        private String secretKey = "eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiJ";

        public String getIssuer() {
            return this.issuer;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Token;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        public String toString() {
            return "ApiAccessProperties.Token(issuer=" + this.getIssuer() + ", secretKey=" + this.getSecretKey() + ")";
        }
    }

    public static class HeaderKey {
        private String token;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeaderKey)) {
                return false;
            }
            HeaderKey other = (HeaderKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HeaderKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        public String toString() {
            return "ApiAccessProperties.HeaderKey(token=" + this.getToken() + ")";
        }
    }

    public static class Database {
        private Boolean enable = true;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Database)) {
                return false;
            }
            Database other = (Database)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enable = this.getEnable();
            Boolean other$enable = other.getEnable();
            return !(this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Database;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enable = this.getEnable();
            result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
            return result;
        }

        public String toString() {
            return "ApiAccessProperties.Database(enable=" + this.getEnable() + ")";
        }
    }

    public static class Cache {
        private Boolean enable = true;
        private Long expireTime = -1L;
        private Key key = new Key();

        public String getSystemListKey() {
            return this.key.getSystemList();
        }

        public String initSystemTokenCacheKey(String id) {
            Assert.notBlank((String)id, (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.key.init(this.key.getSystemToken()) + id;
        }

        public String initManagerCacheKey(String id) {
            Assert.notBlank((String)id, (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.key.init(this.key.getManager()) + id;
        }

        public String initSystemAuthInterfacePathCacheKey(String id) {
            Assert.notBlank((String)id, (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.key.init(this.key.getSystemAuthInterfacePath()) + id;
        }

        public String initInterfaceInfoCacheKey(String id) {
            Assert.notBlank((String)id, (String)"\u63a5\u53e3ID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.key.init(this.key.getInterfaceInfo()) + id;
        }

        public String initInterfaceAuthSystemCacheKey(String id) {
            Assert.notBlank((String)id, (String)"\u63a5\u53e3ID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.key.init(this.key.getInterfaceAuthSystem()) + id;
        }

        public Boolean getEnable() {
            return this.enable;
        }

        public Long getExpireTime() {
            return this.expireTime;
        }

        public Key getKey() {
            return this.key;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }

        public void setKey(Key key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enable = this.getEnable();
            Boolean other$enable = other.getEnable();
            if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
                return false;
            }
            Long this$expireTime = this.getExpireTime();
            Long other$expireTime = other.getExpireTime();
            if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
                return false;
            }
            Key this$key = this.getKey();
            Key other$key = other.getKey();
            return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enable = this.getEnable();
            result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
            Long $expireTime = this.getExpireTime();
            result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
            Key $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            return result;
        }

        public String toString() {
            return "ApiAccessProperties.Cache(enable=" + this.getEnable() + ", expireTime=" + this.getExpireTime() + ", key=" + this.getKey() + ")";
        }

        private static class Key {
            private String keyPrefix = "NARUTO:API_ACCESS:";
            private String login = "ADMIN:LOGIN_TOKEN:";
            private String systemInfo = "SYSTEM:INFO:";
            private String systemList = "SYSTEM:LIST";
            private String systemToken = "SYSTEM:TOKEN:INFO:";
            private String manager = "SYSTEM:MANAGER:INFO:";
            private String interfaceInfo = "INTERFACE:INFO:";
            private String systemAuthInterfaceId = "SYSTEM:AUTH_INTERFACE_ID:";
            private String systemAuthInterfacePath = "SYSTEM:AUTH_INTERFACE_PATH:";
            private String interfaceAuthSystem = "INTERFACE:AUTH_SYSTEM_ID:";

            public String init(String functionKey) {
                return this.keyPrefix + functionKey;
            }

            public String getKeyPrefix() {
                return this.keyPrefix;
            }

            public String getLogin() {
                return this.login;
            }

            public String getSystemInfo() {
                return this.systemInfo;
            }

            public String getSystemList() {
                return this.systemList;
            }

            public String getSystemToken() {
                return this.systemToken;
            }

            public String getManager() {
                return this.manager;
            }

            public String getInterfaceInfo() {
                return this.interfaceInfo;
            }

            public String getSystemAuthInterfaceId() {
                return this.systemAuthInterfaceId;
            }

            public String getSystemAuthInterfacePath() {
                return this.systemAuthInterfacePath;
            }

            public String getInterfaceAuthSystem() {
                return this.interfaceAuthSystem;
            }

            public void setKeyPrefix(String keyPrefix) {
                this.keyPrefix = keyPrefix;
            }

            public void setLogin(String login) {
                this.login = login;
            }

            public void setSystemInfo(String systemInfo) {
                this.systemInfo = systemInfo;
            }

            public void setSystemList(String systemList) {
                this.systemList = systemList;
            }

            public void setSystemToken(String systemToken) {
                this.systemToken = systemToken;
            }

            public void setManager(String manager) {
                this.manager = manager;
            }

            public void setInterfaceInfo(String interfaceInfo) {
                this.interfaceInfo = interfaceInfo;
            }

            public void setSystemAuthInterfaceId(String systemAuthInterfaceId) {
                this.systemAuthInterfaceId = systemAuthInterfaceId;
            }

            public void setSystemAuthInterfacePath(String systemAuthInterfacePath) {
                this.systemAuthInterfacePath = systemAuthInterfacePath;
            }

            public void setInterfaceAuthSystem(String interfaceAuthSystem) {
                this.interfaceAuthSystem = interfaceAuthSystem;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Key)) {
                    return false;
                }
                Key other = (Key)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$keyPrefix = this.getKeyPrefix();
                String other$keyPrefix = other.getKeyPrefix();
                if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
                    return false;
                }
                String this$login = this.getLogin();
                String other$login = other.getLogin();
                if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
                    return false;
                }
                String this$systemInfo = this.getSystemInfo();
                String other$systemInfo = other.getSystemInfo();
                if (this$systemInfo == null ? other$systemInfo != null : !this$systemInfo.equals(other$systemInfo)) {
                    return false;
                }
                String this$systemList = this.getSystemList();
                String other$systemList = other.getSystemList();
                if (this$systemList == null ? other$systemList != null : !this$systemList.equals(other$systemList)) {
                    return false;
                }
                String this$systemToken = this.getSystemToken();
                String other$systemToken = other.getSystemToken();
                if (this$systemToken == null ? other$systemToken != null : !this$systemToken.equals(other$systemToken)) {
                    return false;
                }
                String this$manager = this.getManager();
                String other$manager = other.getManager();
                if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
                    return false;
                }
                String this$interfaceInfo = this.getInterfaceInfo();
                String other$interfaceInfo = other.getInterfaceInfo();
                if (this$interfaceInfo == null ? other$interfaceInfo != null : !this$interfaceInfo.equals(other$interfaceInfo)) {
                    return false;
                }
                String this$systemAuthInterfaceId = this.getSystemAuthInterfaceId();
                String other$systemAuthInterfaceId = other.getSystemAuthInterfaceId();
                if (this$systemAuthInterfaceId == null ? other$systemAuthInterfaceId != null : !this$systemAuthInterfaceId.equals(other$systemAuthInterfaceId)) {
                    return false;
                }
                String this$systemAuthInterfacePath = this.getSystemAuthInterfacePath();
                String other$systemAuthInterfacePath = other.getSystemAuthInterfacePath();
                if (this$systemAuthInterfacePath == null ? other$systemAuthInterfacePath != null : !this$systemAuthInterfacePath.equals(other$systemAuthInterfacePath)) {
                    return false;
                }
                String this$interfaceAuthSystem = this.getInterfaceAuthSystem();
                String other$interfaceAuthSystem = other.getInterfaceAuthSystem();
                return !(this$interfaceAuthSystem == null ? other$interfaceAuthSystem != null : !this$interfaceAuthSystem.equals(other$interfaceAuthSystem));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Key;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $keyPrefix = this.getKeyPrefix();
                result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
                String $login = this.getLogin();
                result = result * 59 + ($login == null ? 43 : $login.hashCode());
                String $systemInfo = this.getSystemInfo();
                result = result * 59 + ($systemInfo == null ? 43 : $systemInfo.hashCode());
                String $systemList = this.getSystemList();
                result = result * 59 + ($systemList == null ? 43 : $systemList.hashCode());
                String $systemToken = this.getSystemToken();
                result = result * 59 + ($systemToken == null ? 43 : $systemToken.hashCode());
                String $manager = this.getManager();
                result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
                String $interfaceInfo = this.getInterfaceInfo();
                result = result * 59 + ($interfaceInfo == null ? 43 : $interfaceInfo.hashCode());
                String $systemAuthInterfaceId = this.getSystemAuthInterfaceId();
                result = result * 59 + ($systemAuthInterfaceId == null ? 43 : $systemAuthInterfaceId.hashCode());
                String $systemAuthInterfacePath = this.getSystemAuthInterfacePath();
                result = result * 59 + ($systemAuthInterfacePath == null ? 43 : $systemAuthInterfacePath.hashCode());
                String $interfaceAuthSystem = this.getInterfaceAuthSystem();
                result = result * 59 + ($interfaceAuthSystem == null ? 43 : $interfaceAuthSystem.hashCode());
                return result;
            }

            public String toString() {
                return "ApiAccessProperties.Cache.Key(keyPrefix=" + this.getKeyPrefix() + ", login=" + this.getLogin() + ", systemInfo=" + this.getSystemInfo() + ", systemList=" + this.getSystemList() + ", systemToken=" + this.getSystemToken() + ", manager=" + this.getManager() + ", interfaceInfo=" + this.getInterfaceInfo() + ", systemAuthInterfaceId=" + this.getSystemAuthInterfaceId() + ", systemAuthInterfacePath=" + this.getSystemAuthInterfacePath() + ", interfaceAuthSystem=" + this.getInterfaceAuthSystem() + ")";
            }
        }
    }
}

