package online.inote.naruto.api.access.aspect;

import online.inote.naruto.api.access.annotation.ApiAccess;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.api.access.validator.ApiAccessValidator;
import online.inote.naruto.utils.spring.SpringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * @description API授权认证切面
 * @author XQF.Sui
 * @date 2021/07/30 13:08
 */
@Order
@Aspect
@Component
public class ApiAccessAspect {

  @Autowired private ApiAccessProperties props;

  @Around("@annotation(apiAccess)")
  public Object around(ProceedingJoinPoint point, ApiAccess apiAccess) throws Throwable {
    ApiAccessValidator.builder()
        .token(SpringUtils.getHttpServletRequest().getHeader(props.getHeaderKey().getToken()))
        .method(SpringUtils.getMethodName(point))
        .execute();

    return point.proceed();
  }
}
