package online.inote.naruto.api.access.spring;

import online.inote.naruto.api.access.aspect.ApiAccessAspect;
import online.inote.naruto.api.access.props.ApiAccessProperties;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.cache.constant.Scan;
import online.inote.naruto.utils.spring.BeanFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

/**
 * @description API Access Spring Configuration
 * @author XQF.Sui
 * @date 2021/07/30 18:52
 */
@Configurable
@EnableAspectJAutoProxy
@Import({ApiAccessAspect.class, ApiAccessProperties.class, BeanFactory.class, CacheSupport.class})
@ComponentScan(value = Scan.SPRING_SCAN_CACHE_PATH)
public class NarutoApiAccessSpringConfiguration {}
