/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.spring.web.controller;

import java.util.Date;
import java.util.UUID;
import online.inote.naruto.annotation.token.WebSecurity;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.security.utils.JwtHelper;
import online.inote.naruto.spring.web.controller.BaseController;
import online.inote.naruto.spring.web.entity.UserEntity;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.time.Calculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user"})
public class UserController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);

    @PostMapping(value={"login"})
    @WebSecurity(required=false)
    public String login(@RequestBody UserEntity user) {
        Assert.notBlank((String)user.getUsername(), (String)"Username cannot be null");
        Assert.notBlank((String)user.getPassword(), (String)"Password cannot be null");
        user.setId(user.getUsername());
        return this.tokenHandle(user);
    }

    public String tokenHandle(UserEntity user) {
        user.setPrivateKey(UUID.randomUUID().toString());
        String token = JwtHelper.genToken((String)user.getId(), (String)user.getUsername(), null, (Date)Calculator.getNowDate());
        CacheSupport.cache((String)(this.props.getCache().getPrefix() + user.getId()), (String)token);
        return token;
    }

    @GetMapping(value={"info"})
    public UserEntity info() {
        String id = this.getUserId();
        UserEntity user = new UserEntity();
        user.setId(id);
        user.setUsername(id);
        return user;
    }
}

