/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.cache.redis;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import online.inote.naruto.annotation.Priority;
import online.inote.naruto.cache.CacheManager;
import online.inote.naruto.common.utils.bean.BeanFactory;
import online.inote.naruto.utils.Assert;
import org.springframework.data.redis.core.StringRedisTemplate;

@Priority
public class NarutoRedisCacheManager
implements CacheManager {
    private static final String DEFAULT_VALUE = "1";
    private StringRedisTemplate redisTemplate = (StringRedisTemplate)BeanFactory.getBean(StringRedisTemplate.class);

    public void cache(String key, String value) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank((String)value, (String)"value\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void cache(String key, long ttl) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ttl > 0L ? 1 : 0) != 0, (String)"ttl\u4e0d\u80fd\u5c0f\u4e8e1");
        this.redisTemplate.opsForValue().set((Object)key, (Object)DEFAULT_VALUE, ttl, TimeUnit.SECONDS);
    }

    public void cache(String key, String value, long ttl) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank((String)value, (String)"value\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ttl > 0L ? 1 : 0) != 0, (String)"ttl\u4e0d\u80fd\u5c0f\u4e8e1");
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, ttl, TimeUnit.SECONDS);
    }

    public Long increment(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    public boolean isExist(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.hasKey((Object)key);
    }

    public void delete(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisTemplate.delete((Object)key);
    }

    public String get(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public Boolean expire(String key, long ttl) {
        return this.expire(key, ttl, TimeUnit.SECONDS);
    }

    public Boolean expire(String key, long ttl, TimeUnit timeUnit) {
        return this.redisTemplate.expire((Object)key, ttl, timeUnit);
    }

    public Long addSet(String key, String ... values) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)values, (String)"values\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Long addSet(String key, Set<String> set) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(set, (String)"set\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])set.toArray(new String[set.size()]));
    }

    public Long remove(String key, String ... values) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)values, (String)"values\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().remove((Object)key, (Object[])values);
    }

    public Boolean move(String key, String value, String destKey) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank((String)value, (String)"value\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank((String)destKey, (String)"destKey\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
    }

    public Set<String> members(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Boolean isMember(String key, String value) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank((String)value, (String)"value\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().isMember((Object)key, (Object)value);
    }

    public Long count(String key) {
        Assert.notBlank((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.opsForSet().size((Object)key);
    }
}

