/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public abstract class SpringBootBindUtils {
    public static final IBind BIND;

    public static <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
        return BIND.bind(environment, targetClass, prefix);
    }

    static {
        IBind bind;
        try {
            Class.forName("org.springframework.boot.context.properties.bind.Binder");
            bind = new SpringBoot2Bind();
        }
        catch (Exception var2) {
            bind = new SpringBoot1Bind();
        }
        BIND = bind;
    }

    public static interface IBind {
        public <T> T bind(Environment var1, Class<T> var2, String var3);
    }

    public static class SpringBoot1Bind
    implements IBind {
        @Override
        public <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
            try {
                Class<?> resolverClass = Class.forName("org.springframework.boot.bind.RelaxedPropertyResolver");
                Constructor<?> resolverConstructor = resolverClass.getDeclaredConstructor(PropertyResolver.class);
                Method getSubPropertiesMethod = resolverClass.getDeclaredMethod("getSubProperties", String.class);
                Object resolver = resolverConstructor.newInstance(environment);
                Map properties = (Map)getSubPropertiesMethod.invoke(resolver, "");
                T target = targetClass.newInstance();
                Class<?> binderClass = Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
                Constructor<?> binderConstructor = binderClass.getDeclaredConstructor(Object.class, String.class);
                Method bindMethod = binderClass.getMethod("bind", PropertyValues.class);
                Object binder = binderConstructor.newInstance(target, prefix);
                bindMethod.invoke(binder, new MutablePropertyValues(properties));
                return target;
            }
            catch (Exception var14) {
                throw new RuntimeException(var14);
            }
        }
    }

    public static class SpringBoot2Bind
    implements IBind {
        @Override
        public <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
            try {
                Class<?> bindClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
                Method getMethod = bindClass.getDeclaredMethod("get", Environment.class);
                Method bindMethod = bindClass.getDeclaredMethod("bind", String.class, Class.class);
                Object bind = getMethod.invoke(null, environment);
                Object bindResult = bindMethod.invoke(bind, prefix, targetClass);
                Method resultGetMethod = bindResult.getClass().getDeclaredMethod("get", new Class[0]);
                Method isBoundMethod = bindResult.getClass().getDeclaredMethod("isBound", new Class[0]);
                return (T)((Boolean)isBoundMethod.invoke(bindResult, new Object[0]) != false ? resultGetMethod.invoke(bindResult, new Object[0]) : null);
            }
            catch (Exception var11) {
                throw new RuntimeException(var11);
            }
        }
    }
}

