/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.common.global;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;
import online.inote.naruto.common.utils.response.ExtendResponse;
import online.inote.naruto.common.utils.response.Response;
import online.inote.naruto.utils.log.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class GlobalResultHandle {
    private static LoggerFactory log = LoggerFactory.getLogger(GlobalResultHandle.class).module("GlobalResultHandle");

    @RestControllerAdvice(value={"cn.creditease"})
    static class CommonResultResponseAdvice
    implements ResponseBodyAdvice<Object> {
        CommonResultResponseAdvice() {
        }

        public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
            return true;
        }

        public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
            return CommonResultResponseAdvice.initResult(body);
        }

        @ExceptionHandler(value={Exception.class})
        public Object exceptionHandle(HttpServletRequest request, Exception e) {
            return CommonResultResponseAdvice.initResult(ExtendResponse.fail(e.getMessage()));
        }

        private static Object initResult(Object body) {
            if (body instanceof Response) {
                return body;
            }
            if (body instanceof String) {
                try {
                    JSONObject o = JSON.parseObject((String)body.toString());
                    if (o.containsKey((Object)"code") && o.containsKey((Object)"message")) {
                        return body;
                    }
                }
                catch (Exception e) {
                    log.error().message("body conversion failed.").throwable((Throwable)e).print();
                    return body;
                }
            }
            return body;
        }
    }
}

