/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.common.utils;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringUtils {
    public static Method getMethod(ProceedingJoinPoint point) {
        try {
            Signature signature = point.getSignature();
            MethodSignature ms = (MethodSignature)signature;
            return point.getTarget().getClass().getMethod(ms.getName(), ms.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new online.inote.naruto.exception.NoSuchMethodException("\u83b7\u53d6\u65b9\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    public static String getMethodName(ProceedingJoinPoint point) {
        return SpringUtils.getClass(point).getName() + '.' + SpringUtils.getMethod(point).getName();
    }

    public static Class<?> getClass(ProceedingJoinPoint point) {
        return point.getTarget().getClass();
    }

    public static HttpServletRequest getHttpServletRequest() {
        return SpringUtils.getServletRequestAttributes().getRequest();
    }

    public static ServletRequestAttributes getServletRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }
}

