/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.common.utils.i18n;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import online.inote.naruto.utils.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18n {
    public static volatile Map<String, ResourceBundle> RESOURCE_BUNDLE_MAP = new ConcurrentHashMap<String, ResourceBundle>();

    public static String message(String bundleName, String key, Object ... args) {
        ResourceBundle bundle = I18n.bundle(bundleName);
        if (bundle == null) {
            return StringUtils.format((String)key, (Object[])args);
        }
        try {
            return StringUtils.format((String)bundle.getString(key), (Object[])args);
        }
        catch (MissingResourceException e) {
            return StringUtils.format((String)key, (Object[])args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle bundle(String bundleName) {
        Locale locale = LocaleContextHolder.getLocale();
        String languageBundleName = bundleName + locale.getLanguage() + locale.getCountry();
        if (!RESOURCE_BUNDLE_MAP.containsKey(languageBundleName)) {
            Map<String, ResourceBundle> map = RESOURCE_BUNDLE_MAP;
            synchronized (map) {
                if (!RESOURCE_BUNDLE_MAP.containsKey(languageBundleName)) {
                    RESOURCE_BUNDLE_MAP.put(languageBundleName, ResourceBundle.getBundle(bundleName, locale));
                }
            }
        }
        return RESOURCE_BUNDLE_MAP.get(languageBundleName);
    }
}

