/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.common.utils.response;

import online.inote.naruto.common.utils.i18n.spring.boot.props.ResponseI18nProperties;
import online.inote.naruto.common.utils.response.Code;
import online.inote.naruto.common.utils.response.Response;
import online.inote.naruto.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class I18nResponse<T>
extends Response<T> {
    private static final long serialVersionUID = -3297318100457726019L;

    I18nResponse() {
    }

    I18nResponse(String code, String message) {
        super(code, message);
    }

    I18nResponse(String code, String message, T data) {
        super(code, message, data);
    }

    public static <T> I18nResponse<T> create(Code code) {
        return new I18nResponse<T>(code.getCode(), code.getMessage(new Object[0]));
    }

    public static <T> I18nResponse<T> create(String code, Object ... args) {
        return new I18nResponse<T>(code, Code.getMessage(code, args));
    }

    public static <T> I18nResponse<T> create(Code code, Object ... args) {
        return new I18nResponse<T>(code.getCode(), code.getMessage(args));
    }

    public boolean isSuccess() {
        return CollectionUtils.containsAny(ResponseI18nProperties.props().getSuccessCode(), (Object[])new String[]{this.code});
    }

    public String getMessage() {
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            return this.message;
        }
        if (StringUtils.isNotBlank((CharSequence)this.code)) {
            return Code.getMessage(this.code, new Object[0]);
        }
        return null;
    }

    public String getI18nMessage() {
        if (StringUtils.isNotBlank((CharSequence)this.code)) {
            return Code.getMessage(this.code, new Object[0]);
        }
        return null;
    }
}

