/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.security.core;

import online.inote.naruto.security.core.TokenHandlerInterceptor;
import online.inote.naruto.security.props.TokenProperties;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class TokenAuthMvcConfigurer
implements WebMvcConfigurer {
    private static final String DEFAULT_CONTEXT_PATH = "/web/**";
    private final TokenProperties props;

    public TokenAuthMvcConfigurer(TokenProperties props) {
        this.props = props;
    }

    @Bean
    TokenHandlerInterceptor tokenHandlerInterceptor() {
        return new TokenHandlerInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (CollectionUtils.isNotEmpty(this.props.getInterceptContextPath())) {
            registry.addInterceptor((HandlerInterceptor)this.tokenHandlerInterceptor()).addPathPatterns(this.props.getInterceptContextPath());
        } else {
            registry.addInterceptor((HandlerInterceptor)this.tokenHandlerInterceptor()).addPathPatterns(new String[]{DEFAULT_CONTEXT_PATH});
        }
    }
}

