/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.security.core;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import online.inote.naruto.annotation.token.WebSecurity;
import online.inote.naruto.cache.CacheSupport;
import online.inote.naruto.common.global.enable.EnableGlobalResultHandle;
import online.inote.naruto.common.utils.response.Code;
import online.inote.naruto.common.utils.response.ExtendResponse;
import online.inote.naruto.common.utils.response.Response;
import online.inote.naruto.security.props.TokenProperties;
import online.inote.naruto.security.utils.JwtHelper;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.StringUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class TokenHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TokenHandlerInterceptor.class);
    @Autowired
    private TokenProperties props;
    @Autowired
    private ApplicationContext context;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            WebSecurity security = null;
            String path = request.getServletPath();
            log.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + path);
            if (method.isAnnotationPresent(WebSecurity.class)) {
                security = method.getAnnotation(WebSecurity.class);
            }
            if (security == null || security.required()) {
                Response<Object> result = this.checkToken(request);
                if (!StringUtils.equals((CharSequence)Code.SUCCESS.getCode(), (CharSequence)result.code)) {
                    if (this.isEnableGlobalResultHandle()) {
                        this.returnError(response, result);
                        return false;
                    }
                    log.info("Token\u9a8c\u8bc1\u672a\u901a\u8fc7,\u539f\u56e0:[ {} ]", (Object)result.message);
                    throw new RuntimeException(result.message);
                }
            }
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String token = request.getHeader(this.props.getHeader().getKey());
        if (StringUtils.isNotBlank((CharSequence)token)) {
            CacheSupport.cache((String)this.getTokenCacheKey(token), (String)token, (long)this.props.getCache().getExpireTime());
        }
    }

    private Response<Object> checkToken(HttpServletRequest request) {
        String token = request.getHeader(this.props.getHeader().getKey());
        Assert.notBlank((String)token, (String)"Token\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            String redisToken = CacheSupport.get((String)this.getTokenCacheKey(token));
            if (StringUtils.isBlank((CharSequence)redisToken)) {
                log.info("Token\u8ba4\u8bc1\u5931\u8d25,Token\u767b\u5f55\u8d85\u65f6");
                return ExtendResponse.create((String)Code.FAIL.getCode(), (String)"Token\u767b\u5f55\u8d85\u65f6");
            }
            if (!StringUtils.equals((CharSequence)redisToken, (CharSequence)token)) {
                log.info("Token\u8ba4\u8bc1\u5931\u8d25,\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u9646");
                return ExtendResponse.create((String)Code.FAIL.getCode(), (String)"\u8d26\u53f7\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u9646");
            }
        }
        catch (Exception e) {
            log.error("Token\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            return ExtendResponse.create((String)Code.FAIL.getCode(), (String)"Token\u9a8c\u8bc1\u5f02\u5e38");
        }
        return ExtendResponse.create((String)Code.SUCCESS.getCode(), (String)"Token\u9a8c\u8bc1\u5f02\u5e38");
    }

    private String getTokenCacheKey(String token) {
        return this.props.getCache().getPrefix() + ((Claims)JwtHelper.getClaims(token).getBody()).getId();
    }

    private boolean isEnableGlobalResultHandle() {
        Map beanMap = this.context.getBeansWithAnnotation(SpringBootApplication.class);
        if (MapUtils.isEmpty((Map)beanMap)) {
            return false;
        }
        return beanMap.values().toArray()[0].getClass().getSuperclass().isAnnotationPresent(EnableGlobalResultHandle.class);
    }

    private void returnError(HttpServletResponse response, Response<Object> result) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try (PrintWriter writer = response.getWriter();){
            writer.write(JSON.toJSONString(result));
            writer.flush();
        }
    }
}

