/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.security.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import online.inote.naruto.security.props.TokenProperties;
import online.inote.naruto.utils.time.Calculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtHelper {
    private static final Logger log = LoggerFactory.getLogger(JwtHelper.class);

    public static String genToken(Map<String, Object> claimMap) {
        return Jwts.builder().addClaims(claimMap).setIssuedAt(Calculator.getNowDate()).signWith(SignatureAlgorithm.HS256, JwtHelper.genKey()).compact();
    }

    public static String genToken(String id, String username, Map<String, Object> claimMap, Date createTime) {
        return JwtHelper.genToken(id, username, claimMap, createTime, null);
    }

    public static String genToken(String id, String username, Map<String, Object> claimMap, Date createTime, Date expireTime) {
        if (log.isDebugEnabled()) {
            log.debug("genToken [ id:{} ], [ username:{} ], [ claimMap:{} ], [ createTime:{} ], [ expireTime:{} ]", new Object[]{id, username, claimMap, createTime, expireTime});
            Key key = JwtHelper.genKey();
            log.debug("genToken [ genKey:{} ]", (Object)(key.getAlgorithm() + "|" + key.getFormat() + "|" + key.getEncoded().toString()));
        }
        return Jwts.builder().setId(id).setAudience(username).addClaims(claimMap).setIssuedAt(createTime).setExpiration(expireTime).signWith(SignatureAlgorithm.HS256, JwtHelper.genKey()).compact();
    }

    public static Key genKey() {
        return new SecretKeySpec(TokenProperties.props().getSecretKey().getBytes(), SignatureAlgorithm.HS256.getJcaName());
    }

    public static Jws<Claims> getClaims(String token) {
        return Jwts.parser().setSigningKey(JwtHelper.genKey()).parseClaimsJws(token);
    }
}

