package online.inote.naruto.utils.http;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description MediaType enum
 * @author gaopengsui@creditease.cn
 * @date 2022/08/23 21:23
 */
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum MediaTypeEnum {

  /** text */
  TEXT("text"),

  /** json */
  JSON("json"),

  /** html */
  HTML("html"),

  /** web view html */
  WEB_VIEW_HTML("webviewhtml");

  private static Map<String, MediaTypeEnum> MEDIA_TYPE_MAP;

  static {
    MEDIA_TYPE_MAP =
        Arrays.stream(MediaTypeEnum.values())
            .collect(Collectors.toMap(MediaTypeEnum::getType, m -> m));
  }

  private String type;

  public static boolean contains(String mediaType) {
    return MEDIA_TYPE_MAP.containsKey(mediaType);
  }
}
