package online.inote.naruto.utils.log;

/**
 * @description Error Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 11:07 下午
 */
public class ErrorLogger extends Logger {

  protected ErrorLogger(org.slf4j.Logger logger, String module) {
    super(logger, module);
  }

  /**
   * 输出
   *
   * @param message 消息
   */
  @Override
  public void print(String message) {
    if (this.getLogger().isErrorEnabled()) {
      this.getLogger().error(message);
    }
  }

  /**
   * 输出
   *
   * @param message 消息
   * @param throwable 异常
   */
  @Override
  public void print(String message, Throwable throwable) {
    if (this.getLogger().isErrorEnabled()) {
      this.getLogger().error(message, throwable);
    }
  }
}
