/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import java.util.Collection;
import java.util.Objects;
import online.inote.naruto.exception.ArgumentException;
import org.apache.commons.lang3.StringUtils;

public final class Assert {
    private Assert() {
    }

    public static void isNull(Object obj, String message) {
        if (!Objects.isNull(obj)) {
            throw new ArgumentException(message);
        }
    }

    public static void nonNull(Object obj, String message) {
        if (Objects.isNull(obj)) {
            throw new ArgumentException(message);
        }
    }

    public static void isEmpty(Collection collection, String message) {
        if (collection != null && !collection.isEmpty()) {
            throw new ArgumentException(message);
        }
    }

    public static void nonEmpty(Collection collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new ArgumentException(message);
        }
    }

    public static void isEmpty(String str, String message) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            throw new ArgumentException(message);
        }
    }

    public static void nonEmpty(String str, String message) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new ArgumentException(message);
        }
    }

    public static void nonBlank(String str, String message) {
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new ArgumentException(message);
        }
    }

    public static void isTrue(boolean b, String message) {
        if (!b) {
            throw new ArgumentException(message);
        }
    }

    public static void isFalse(boolean b, String message) {
        if (b) {
            throw new ArgumentException(message);
        }
    }
}

