/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.http;

import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import online.inote.naruto.utils.http.Result;
import org.apache.commons.collections4.MapUtils;

public abstract class Request {
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType APPLICATION_FORM_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    protected String baseUrl;
    protected String url;
    protected String targetUrl;
    protected Object requestBody;
    protected Map<String, Object> headerParamMap = new HashMap<String, Object>();
    protected Map<String, Object> urlParamMap = new HashMap<String, Object>();
    protected Map<String, Object> requestBodyMap = new HashMap<String, Object>();
    protected Map<String, Object> formParamMap = new HashMap<String, Object>();
    protected Object formBody;
    protected MediaType mediaType = APPLICATION_JSON;

    public abstract Result get();

    public abstract Result post();

    public abstract Result postForm();

    public abstract Result put();

    public abstract Result delete();

    public Request setRequestBody(Object params) {
        this.requestBody = params;
        return this;
    }

    public Request setRequestBody(String key, Object val) {
        this.requestBodyMap.put(key, val);
        return this;
    }

    public Request setFormBody(Object params) {
        this.formBody = params;
        return this;
    }

    public Request setFormParamMap(String key, Object val) {
        this.formParamMap.put(key, val);
        return this;
    }

    public Request setHeaderParam(String key, String val) {
        this.headerParamMap.put(key, val);
        return this;
    }

    public Request setHeaderParam(Map<String, Object> headerParamMap) {
        if (MapUtils.isNotEmpty(headerParamMap)) {
            this.headerParamMap.putAll(headerParamMap);
        }
        return this;
    }

    public Request setUrlParam(String key, String val) {
        this.urlParamMap.put(key, val);
        return this;
    }

    public Request setUrlParam(Map<String, Object> urlParamMap) {
        if (MapUtils.isNotEmpty(urlParamMap)) {
            this.urlParamMap.putAll(this.headerParamMap);
        }
        return this;
    }

    public Request setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Request setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.targetUrl = this.baseUrl + this.url;
        return this;
    }

    public Request setUrl(String url) {
        this.url = url;
        this.targetUrl = this.baseUrl + this.url;
        return this;
    }

    public Request setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }
}

