/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import online.inote.naruto.exception.HttpException;
import online.inote.naruto.utils.StringUtils;
import online.inote.naruto.utils.http.Request;
import online.inote.naruto.utils.http.Result;
import online.inote.naruto.utils.http.ResultConvertor;
import org.apache.commons.collections4.MapUtils;

public class SyncRequest
extends Request {
    private OkHttpClient client;
    private ResultConvertor convertor;

    @Override
    public Result get() {
        Response response = null;
        try {
            response = this.client.newCall(this.buildRequest().build()).execute();
        }
        catch (IOException e) {
            throw new HttpException("http\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return Result.builder().response(response).convertor(this.convertor).build();
    }

    @Override
    public Result post() {
        return this.post(this.buildBody());
    }

    @Override
    public Result postForm() {
        return this.post((RequestBody)this.buildFormBody());
    }

    private Result post(RequestBody body) {
        Response response = null;
        try {
            response = this.client.newCall(this.buildRequest().post(body).build()).execute();
        }
        catch (IOException e) {
            throw new HttpException("http\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return Result.builder().response(response).convertor(this.convertor).build();
    }

    private FormBody buildFormBody() {
        FormBody.Builder builder = new FormBody.Builder();
        if (Objects.nonNull(this.formBody)) {
            JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)this.formBody));
            object.keySet().forEach(key -> builder.add(key, object.getString(key)));
        } else if (MapUtils.isNotEmpty((Map)this.formParamMap)) {
            this.formParamMap.keySet().forEach(key -> builder.add(key, MapUtils.getString((Map)this.formParamMap, (Object)key)));
        }
        return builder.build();
    }

    @Override
    public Result put() {
        return null;
    }

    @Override
    public Result delete() {
        return null;
    }

    private Request.Builder buildRequest() {
        String urlParams = StringUtils.convertToUrlParams(this.urlParamMap);
        Request.Builder builder = new Request.Builder().url(this.targetUrl + (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)urlParams) ? "" : urlParams));
        if (MapUtils.isNotEmpty((Map)this.headerParamMap)) {
            this.headerParamMap.forEach((key, val) -> builder.addHeader(key, String.valueOf(val)));
        }
        return builder;
    }

    private RequestBody buildBody() {
        RequestBody body = null;
        body = Objects.nonNull(this.requestBody) ? (this.requestBody instanceof String ? RequestBody.create((MediaType)this.mediaType, (String)this.requestBody.toString()) : RequestBody.create((MediaType)this.mediaType, (String)JSON.toJSONString((Object)this.requestBody))) : (MapUtils.isNotEmpty((Map)this.requestBodyMap) ? RequestBody.create((MediaType)this.mediaType, (String)JSON.toJSONString((Object)this.requestBodyMap)) : RequestBody.create((MediaType)this.mediaType, (String)"{}"));
        return body;
    }

    SyncRequest(OkHttpClient client, ResultConvertor convertor) {
        this.client = client;
        this.convertor = convertor;
    }

    public static SyncRequestBuilder builder() {
        return new SyncRequestBuilder();
    }

    public static class SyncRequestBuilder {
        private OkHttpClient client;
        private ResultConvertor convertor;

        SyncRequestBuilder() {
        }

        public SyncRequestBuilder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public SyncRequestBuilder convertor(ResultConvertor convertor) {
            this.convertor = convertor;
            return this;
        }

        public SyncRequest build() {
            return new SyncRequest(this.client, this.convertor);
        }

        public String toString() {
            return "SyncRequest.SyncRequestBuilder(client=" + this.client + ", convertor=" + this.convertor + ")";
        }
    }
}

