/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.log;

import java.util.Objects;
import online.inote.naruto.utils.Assert;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public abstract class Logger {
    private static final String MODULE_SURROUND_BEGIN = "[";
    private static final String MODULE_SURROUND_END = "]";
    private static final String MODULE_SPLIT_STR = ": ";
    private org.slf4j.Logger logger;
    private String module;
    private String message;
    private Object[] arguments;
    private Throwable throwable;

    protected Logger(org.slf4j.Logger logger, String module) {
        Assert.nonNull(logger, "logger cannot be null.");
        this.logger = logger;
        this.module = module;
    }

    public Logger module(String module) {
        this.module = module;
        return this;
    }

    public Logger message(String message) {
        this.message = message;
        return this;
    }

    public Logger args(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public Logger throwable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public void print() {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)this.initMessage(), (Object[])this.arguments);
        if (Objects.isNull(this.throwable)) {
            this.print(tuple.getMessage());
        } else {
            this.print(tuple.getMessage(), this.throwable);
        }
    }

    private String initMessage() {
        if (!StringUtils.isBlank((CharSequence)this.module)) {
            return this.message;
        }
        return MODULE_SURROUND_BEGIN + this.module + MODULE_SURROUND_END + MODULE_SPLIT_STR + this.message;
    }

    protected abstract void print(String var1);

    protected abstract void print(String var1, Throwable var2);

    protected org.slf4j.Logger getLogger() {
        return this.logger;
    }
}

