/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils.response;

import java.io.Serializable;
import online.inote.naruto.utils.response.CodeMessage;
import online.inote.naruto.utils.response.CommonCodeMessage;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = 1940009865956053614L;
    private String code;
    private String message;
    private T data;

    public Response(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static <T> Response<T> create(String code, String message) {
        return new Response<T>(code, message);
    }

    public static <T> Response<T> create(String code, String message, T data) {
        return new Response<T>(code, message, data);
    }

    public static <T> Response<T> create(CodeMessage codeMessage, T data) {
        return new Response<T>(codeMessage.getCode(), codeMessage.getMessage(), data);
    }

    public static <T> Response<T> success(T data) {
        return Response.create(CommonCodeMessage.SUCCESS.getCode(), CommonCodeMessage.SUCCESS.getMessage(), data);
    }

    public static <T> Response<T> fail() {
        return Response.create(CommonCodeMessage.FAIL.getCode(), CommonCodeMessage.FAIL.getMessage());
    }

    public static <T> Response<T> fail(String message) {
        return Response.create(CommonCodeMessage.FAIL.getCode(), message);
    }

    public boolean isSuccess() {
        return CommonCodeMessage.SUCCESS.getCode().equals(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public Response(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Response() {
    }

    public static final class Fields {
        public static final String code = "code";
        public static final String message = "message";
        public static final String data = "data";

        private Fields() {
        }
    }
}

