package online.inote.naruto.utils;

import online.inote.naruto.exception.NarutoArgumentException;

import java.util.Collection;
import java.util.Objects;

/**
 * @description 断言
 * @author XQF.Sui
 * @date 2021/07/29 22:50
 */
public final class Assert {

  private Assert() {}

  public static void isNull(Object obj, String message) {
    if (!Objects.isNull(obj)) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void notNull(Object obj, String message) {
    if (Objects.isNull(obj)) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void isEmpty(Collection collection, String message) {
    if (collection != null && !collection.isEmpty()) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void notEmpty(Collection collection, String message) {
    if (collection == null || collection.isEmpty()) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void isEmpty(String str, String message) {
    if (StringUtils.isNotEmpty(str)) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void notEmpty(String str, String message) {
    if (StringUtils.isEmpty(str)) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void notBlank(String str, String message) {
    if (StringUtils.isBlank(str)) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void isTrue(boolean b, String message) {
    if (!b) {
      throw new NarutoArgumentException(message);
    }
  }

  public static void isFalse(boolean b, String message) {
    if (b) {
      throw new NarutoArgumentException(message);
    }
  }
}
