package online.inote.naruto.utils.spring;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.lang.annotation.Annotation;
import java.util.Map;

/**
 * @description Spring bean工具类(要项目此类生效需要配置Spring扫描路径包含当前类的路径)
 * @author XQF.Sui
 * @date 2017年12月5日 下午5:31:21
 */
@Component
public class BeanFactory implements ApplicationContextAware {

  private static ApplicationContext context;

  @Override
  public void setApplicationContext(ApplicationContext context) throws BeansException {
    setAppContext(context);
  }

  private synchronized void setAppContext(ApplicationContext context) {
    BeanFactory.context = context;
  }

  public static ApplicationContext getApplicationContext() {
    return context;
  }

  public static Object getBean(String name) {
    return context.getBean(name);
  }

  public static <T> T getBean(Class<T> clazz) {
    return context.getBean(clazz);
  }

  public static <T> T getBean(String name, Class<T> clazz) {
    return context.getBean(name, clazz);
  }

  public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> clazz) {
    return context.getBeansWithAnnotation(clazz);
  }

  public static Map<String, ?> getBeansWithType(Class<?> clazz) {
    return context.getBeansOfType(clazz);
  }
}
