package online.inote.naruto.utils;

/**
 * @description StringUtils
 * @author XQF.Sui
 * @date 2021/07/29 23:18
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {

  private static final String TEMPLATE_PLACEHOLDER_PREFIX = "{";
  private static final String TEMPLATE_PLACEHOLDER_SUFFIX = "}";

  public static String replaceParams(String template, Object... params) {
    int i = 0;

    while (i < params.length && template.contains(TEMPLATE_PLACEHOLDER_PREFIX)) {
      int index = template.indexOf(TEMPLATE_PLACEHOLDER_SUFFIX), strLen = template.length();

      if (index == strLen - 1) {
        template = template.substring(0, template.indexOf(TEMPLATE_PLACEHOLDER_PREFIX)) + params[i];
      } else {
        template =
            template.substring(0, template.indexOf(TEMPLATE_PLACEHOLDER_PREFIX))
                + params[i]
                + template.substring(template.indexOf(TEMPLATE_PLACEHOLDER_SUFFIX) + 1);
      }

      i++;
    }

    return template;
  }

  /**
   * 使字符串以指定前缀开始
   *
   * @param str
   * @param prefix
   * @return
   */
  public static String setupStartsAt(String str, CharSequence prefix) {
    if (startsWith(str, prefix)) {
      return str;
    } else {
      return prefix + str;
    }
  }
}
