/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import online.inote.naruto.utils.StringUtils;

public class ResultFactory<T>
implements Serializable {
    private static final long serialVersionUID = -3793616609751038854L;
    public String code;
    public String message;
    public T data;

    private ResultFactory() {
    }

    private ResultFactory(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private ResultFactory(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public JSONObject dataToJsonObject() {
        try {
            if (this.data == null) {
                return null;
            }
            return JSON.parseObject((String)JSON.toJSONString(this.data));
        }
        catch (Exception e) {
            throw new RuntimeException("data\u8f6c\u6362JSONObject\u5931\u8d25");
        }
    }

    public static ResultFactory<Object> as(String content) {
        return (ResultFactory)JSON.parseObject((String)content, (TypeReference)new TypeReference<ResultFactory<Object>>(){}, (Feature[])new Feature[0]);
    }

    public String toJson() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public JSONObject toJsonObject() {
        return JSON.parseObject((String)this.toJson());
    }

    public static <T> ResultFactory<T> success() {
        return new ResultFactory<T>(ResultEnum.SUCCESS.key, ResultEnum.SUCCESS.msg);
    }

    public static <T> ResultFactory<T> success(T data) {
        return new ResultFactory<T>(ResultEnum.SUCCESS.key, ResultEnum.SUCCESS.msg, data);
    }

    public static <T> ResultFactory<T> success(T data, String message) {
        return new ResultFactory<T>(ResultEnum.SUCCESS.key, message, data);
    }

    public static <T> ResultFactory<T> fail() {
        return new ResultFactory<Object>(ResultEnum.FAIL.key, ResultEnum.FAIL.msg, null);
    }

    public static <T> ResultFactory<T> fail(String message) {
        return new ResultFactory<Object>(ResultEnum.FAIL.key, message, null);
    }

    public static <T> ResultFactory<T> fail(String message, Object ... o) {
        return new ResultFactory<Object>(ResultEnum.FAIL.key, StringUtils.replaceParams(message, o), null);
    }

    public static <T> ResultFactory<T> create(ResultEnum result) {
        return new ResultFactory<Object>(result.key, result.msg, null);
    }

    public static <T> ResultFactory<T> create(ResultEnum result, String message) {
        return new ResultFactory<Object>(result.key, message, null);
    }

    public static ResultFactory<String> create(String data, ResultEnum result) {
        return new ResultFactory<String>(result.key, result.msg, data);
    }

    public static <T> ResultFactory<T> create(ResultEnum result, T t) {
        return new ResultFactory<T>(result.key, result.msg, t);
    }

    public static <T> ResultFactory<T> create(ResultEnum result, String message, T t) {
        return new ResultFactory<T>(result.key, message, t);
    }

    public static <T> ResultFactory<T> create(String code, String message) {
        return new ResultFactory<T>(code, message);
    }

    public static <T> ResultFactory<T> create(ResultEnum result, String message, Object ... o) {
        return new ResultFactory<Object>(result.key, StringUtils.replaceParams(message, o), null);
    }

    public static boolean isSuccess(ResultFactory<Object> factory) {
        return factory != null && ResultEnum.SUCCESS.key.equals(factory.code);
    }

    public boolean isSuccess() {
        return ResultEnum.SUCCESS.key.equals(this.code);
    }

    public static enum ResultEnum {
        SUCCESS("A10001", "\u6210\u529f"),
        FAIL("A10002", "\u5931\u8d25"),
        PARAM_REQUIRED("A10003", "\u53c2\u6570\u5fc5\u586b"),
        NOT_EXISTS("A10004", "\u8be5\u4fe1\u606f\u4e0d\u5b58\u5728"),
        EXISTS("A10005", "\u8be5\u4fe1\u606f\u5df2\u5b58\u5728"),
        OWN_PERMISSION("A10006", "\u6709\u6743\u9650"),
        NOT_PERMISSION("A10007", "\u6ca1\u6709\u6743\u9650"),
        TOKEN_ILLEGAL("A50008", "\u975e\u6cd5\u4ee4\u724c"),
        TOKEN_EXPIRED("A50014", "\u767b\u5f55\u8d85\u65f6");

        private String key;
        private String msg;

        public String getKey() {
            return this.key;
        }

        public String getMsg() {
            return this.msg;
        }

        private ResultEnum(String key, String msg) {
            this.key = key;
            this.msg = msg;
        }
    }
}

