package online.inote.naruto.utils;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @description 分页
 * @author XQF.Sui
 * @date 2017年12月4日 上午11:03:54
 */
@Data
public class Page<T> {

  /** 当前页 默认第一页 */
  private int page = 1;

  /** 每页显示条数 默认每页显示10条 */
  private int rows = 10;

  /** 总页数 */
  private long totalPage;

  /** 总数 */
  private long records;

  /** 是否有下一页 */
  private boolean hasNext;

  /** 是否有上一页 */
  private boolean hasPrevious;

  /** 获取的数据 */
  private List<T> dataList;

  /** 分页搜索参数 */
  private Map<String, Object> searchParamsMap;

  /** 分页搜索参数对象 */
  private T searchParams;

  public Page() {
    super();
  }

  public Page(int page, int rows) {
    this();
    this.page = page > 0 ? page : 1;
    this.rows = rows > 0 ? rows : 30;
  }

  public Page(int page, int rows, long records) {
    this(page, rows);
    this.setRecords(records);
  }

  public void setRecords(long records) {
    this.records = records;
    this.totalPage = (long) Math.ceil((double) records / this.rows);
    //    this.page = this.totalPage > this.page ? this.page : (int) this.totalPage;
    this.hasNext = this.totalPage > this.page;
    this.hasPrevious = this.page > 1;
  }

  @JSONField(serialize = false)
  public int getEsPage() {
    return this.page > 0 ? this.page - 1 : 0;
  }

  @JSONField(serialize = false)
  public int getStart() {
    return (this.page - 1) * this.rows;
  }
}
