/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import online.inote.naruto.utils.Assert;
import online.inote.naruto.utils.StringUtils;
import org.springframework.util.DigestUtils;

public class MdFiveUtils {
    private static final String SALT = DigestUtils.md5DigestAsHex((byte[])"NARUTO-SECURITY".getBytes(StandardCharsets.UTF_8));
    private static final String EMPTY_JSON = "{}";

    public static String encrypt(String data) {
        return DigestUtils.md5DigestAsHex((byte[])(SALT + data).getBytes(StandardCharsets.UTF_8));
    }

    public static String digest(DigestWorker worker) {
        return MdFiveUtils.digest(worker.nonce, worker.url, worker.timestamp, worker.token, worker.params, worker.arguments);
    }

    public static String digest(String nonce, String url, Long timestamp, String token, Object ... arguments) {
        return MdFiveUtils.digest(nonce, url, timestamp, token, null, arguments);
    }

    public static String digest(String nonce, String url, Long timestamp, String token, String params, Object ... arguments) {
        Assert.notBlank(nonce, "nonce\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notBlank(url, "url\u4e0d\u80fd\u4e3a\u7a7a");
        StringBuilder sb = new StringBuilder(SALT + nonce + url);
        if (!Objects.isNull(timestamp)) {
            sb.append(timestamp);
        }
        if (!Objects.isNull(token)) {
            sb.append(token);
        }
        if (StringUtils.isNotBlank((CharSequence)params) && !StringUtils.equals((CharSequence)params, (CharSequence)EMPTY_JSON)) {
            sb.append(params);
        }
        sb.append(MdFiveUtils.argumentsSort(arguments));
        return DigestUtils.md5DigestAsHex((byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String argumentsSort(Object ... arguments) {
        if (arguments != null && arguments.length > 0) {
            List list = Arrays.stream(arguments).sorted(Comparator.comparing(Object::hashCode)).collect(Collectors.toList());
            char[] chars = JSON.toJSONString(list).toCharArray();
            Arrays.sort(chars);
            return Arrays.toString(chars);
        }
        return "";
    }

    public static DigestWorker builder() {
        return new DigestWorker();
    }

    public static class DigestWorker {
        private String nonce;
        private String url;
        private Long timestamp;
        private String token;
        private String params;
        private Object[] arguments;

        public DigestWorker nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public DigestWorker url(String url) {
            this.url = url;
            return this;
        }

        public DigestWorker timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DigestWorker token(String token) {
            this.token = token;
            return this;
        }

        public DigestWorker params(String params) {
            this.params = params;
            return this;
        }

        public DigestWorker arguments(Object ... arguments) {
            this.arguments = arguments;
            return this;
        }

        public String execute() {
            return MdFiveUtils.digest(this);
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getUrl() {
            return this.url;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String getToken() {
            return this.token;
        }

        public String getParams() {
            return this.params;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public void setArguments(Object[] arguments) {
            this.arguments = arguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DigestWorker)) {
                return false;
            }
            DigestWorker other = (DigestWorker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$params = this.getParams();
            String other$params = other.getParams();
            if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
                return false;
            }
            return Arrays.deepEquals(this.getArguments(), other.getArguments());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DigestWorker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArguments());
            return result;
        }

        public String toString() {
            return "MdFiveUtils.DigestWorker(nonce=" + this.getNonce() + ", url=" + this.getUrl() + ", timestamp=" + this.getTimestamp() + ", token=" + this.getToken() + ", params=" + this.getParams() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ")";
        }
    }
}

