/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.utils;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import java.util.Map;

public class Page<T> {
    private int page = 1;
    private int rows = 10;
    private long totalPage;
    private long records;
    private boolean hasNext;
    private boolean hasPrevious;
    private List<T> dataList;
    private Map<String, Object> searchParamsMap;
    private T searchParams;

    public Page() {
    }

    public Page(int page, int rows) {
        this();
        this.page = page > 0 ? page : 1;
        this.rows = rows > 0 ? rows : 30;
    }

    public Page(int page, int rows, long records) {
        this(page, rows);
        this.setRecords(records);
    }

    public void setRecords(long records) {
        this.records = records;
        this.totalPage = (long)Math.ceil((double)records / (double)this.rows);
        this.hasNext = this.totalPage > (long)this.page;
        this.hasPrevious = this.page > 1;
    }

    @JSONField(serialize=false)
    public int getEsPage() {
        return this.page > 0 ? this.page - 1 : 0;
    }

    @JSONField(serialize=false)
    public int getStart() {
        return (this.page - 1) * this.rows;
    }

    public int getPage() {
        return this.page;
    }

    public int getRows() {
        return this.rows;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public long getRecords() {
        return this.records;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    public boolean isHasPrevious() {
        return this.hasPrevious;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public Map<String, Object> getSearchParamsMap() {
        return this.searchParamsMap;
    }

    public T getSearchParams() {
        return this.searchParams;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public void setHasPrevious(boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public void setSearchParamsMap(Map<String, Object> searchParamsMap) {
        this.searchParamsMap = searchParamsMap;
    }

    public void setSearchParams(T searchParams) {
        this.searchParams = searchParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getRecords() != other.getRecords()) {
            return false;
        }
        if (this.isHasNext() != other.isHasNext()) {
            return false;
        }
        if (this.isHasPrevious() != other.isHasPrevious()) {
            return false;
        }
        List<T> this$dataList = this.getDataList();
        List<T> other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        Map<String, Object> this$searchParamsMap = this.getSearchParamsMap();
        Map<String, Object> other$searchParamsMap = other.getSearchParamsMap();
        if (this$searchParamsMap == null ? other$searchParamsMap != null : !((Object)this$searchParamsMap).equals(other$searchParamsMap)) {
            return false;
        }
        T this$searchParams = this.getSearchParams();
        T other$searchParams = other.getSearchParams();
        return !(this$searchParams == null ? other$searchParams != null : !this$searchParams.equals(other$searchParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getRows();
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        long $records = this.getRecords();
        result = result * 59 + (int)($records >>> 32 ^ $records);
        result = result * 59 + (this.isHasNext() ? 79 : 97);
        result = result * 59 + (this.isHasPrevious() ? 79 : 97);
        List<T> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        Map<String, Object> $searchParamsMap = this.getSearchParamsMap();
        result = result * 59 + ($searchParamsMap == null ? 43 : ((Object)$searchParamsMap).hashCode());
        T $searchParams = this.getSearchParams();
        result = result * 59 + ($searchParams == null ? 43 : $searchParams.hashCode());
        return result;
    }

    public String toString() {
        return "Page(page=" + this.getPage() + ", rows=" + this.getRows() + ", totalPage=" + this.getTotalPage() + ", records=" + this.getRecords() + ", hasNext=" + this.isHasNext() + ", hasPrevious=" + this.isHasPrevious() + ", dataList=" + this.getDataList() + ", searchParamsMap=" + this.getSearchParamsMap() + ", searchParams=" + this.getSearchParams() + ")";
    }
}

