package online.inote.naruto.utils.log;

/**
 * @description Info Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 11:04 下午
 */
public class InfoLogger extends Logger {

  protected InfoLogger(org.slf4j.Logger logger, String module) {
    super(logger, module);
  }

  /**
   * 输出
   *
   * @param message 消息
   */
  @Override
  protected void print(String message) {
    if (this.getLogger().isInfoEnabled()) {
      this.getLogger().info(message);
    }
  }

  /**
   * 输出
   *
   * @param message 消息
   * @param throwable 异常
   */
  @Override
  protected void print(String message, Throwable throwable) {
    if (this.getLogger().isInfoEnabled()) {
      this.getLogger().info(message, throwable);
    }
  }
}
