package online.inote.naruto.utils.log;

import online.inote.naruto.utils.Assert;

/**
 * @description Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 10:04 下午
 */
public final class LoggerFactory {

  private org.slf4j.Logger logger;
  private String module;

  private LoggerFactory() {}

  private LoggerFactory(org.slf4j.Logger logger) {
    this.logger = logger;
  }

  public LoggerFactory module(String module) {
    this.module = module;
    return this;
  }

  public TraceLogger trace() {
    return new TraceLogger(this.logger, this.module);
  }

  public DebugLogger debug() {
    return new DebugLogger(this.logger, this.module);
  }

  public InfoLogger info() {
    return new InfoLogger(this.logger, this.module);
  }

  public WarnLogger warn() {
    return new WarnLogger(this.logger, this.module);
  }

  public ErrorLogger error() {
    return new ErrorLogger(this.logger, this.module);
  }

  public static LoggerFactory getLogger(Class<?> clazz) {
    return LoggerFactory.builder().logger(clazz).build();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private org.slf4j.Logger logger;

    public Builder logger(Class<?> clazz) {
      this.logger = org.slf4j.LoggerFactory.getLogger(clazz);
      return this;
    }

    public LoggerFactory build() {
      Assert.notNull(this.logger, "logger cannot be null.");
      return new LoggerFactory(this.logger);
    }
  }
}
