package online.inote.naruto.utils.log;

/**
 * @description Trace Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 10:59 下午
 */
public class TraceLogger extends Logger {

  protected TraceLogger(org.slf4j.Logger logger, String module) {
    super(logger, module);
  }

  /**
   * 输出
   *
   * @param message 消息
   */
  @Override
  protected void print(String message) {
    if (this.getLogger().isTraceEnabled()) {
      this.getLogger().trace(message);
    }
  }

  /**
   * 输出
   *
   * @param message 消息
   * @param throwable 异常
   */
  @Override
  protected void print(String message, Throwable throwable) {
    if (this.getLogger().isTraceEnabled()) {
      this.getLogger().trace(message, throwable);
    }
  }
}
