package online.inote.naruto.utils.log;

/**
 * @description Warn Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 11:05 下午
 */
public class WarnLogger extends Logger {

  protected WarnLogger(org.slf4j.Logger logger, String module) {
    super(logger, module);
  }

  /**
   * 输出
   *
   * @param message 消息
   */
  @Override
  protected void print(String message) {
    if (this.getLogger().isWarnEnabled()) {
      this.getLogger().warn(message);
    }
  }

  /**
   * 输出
   *
   * @param message 消息
   * @param throwable 异常
   */
  @Override
  protected void print(String message, Throwable throwable) {
    if (this.getLogger().isWarnEnabled()) {
      this.getLogger().warn(message, throwable);
    }
  }
}
