package online.inote.naruto.utils.time;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

/**
 * @description DateTime
 * @author gaopengsui@creditease.cn
 * @date 2021/10/15 2:00 下午
 */
@Data
public class DateTime {
  private LocalDateTime dateTime;

  public DateTime() {
    this.dateTime = Calculator.getNow();
  }

  public DateTime(LocalDateTime dateTime) {
    this.dateTime = dateTime;
  }

  public LocalDateTime toLocalDateTime() {
    return this.dateTime;
  }

  public Date toDate() {
    return Converter.toDate(this.dateTime);
  }

  public LocalDate toLocalDate() {
    return Converter.toLocalDate(this.dateTime);
  }

  public LocalTime toLocalTime() {
    return Converter.toLocalTime(this.dateTime);
  }
}
