/**
 * @description 日期时间包
 * @author gaopengsui@creditease.cn
 * @date 2021/09/10 19:37
 */
package online.inote.naruto.utils.time;

import java.time.ZoneId;

/**
 * @description 常用时区
 * @author gaopengsui@creditease.cn
 * @date 2021/9/13 17:52
 */
class Zone {

  /** 系统默认时区 */
  public static final ZoneId DEFAULT = ZoneId.systemDefault();

  /** 上海时区 */
  public static final ZoneId SH_ZONE = ZoneId.of(ZoneEnum.CTT.getName());

  /** 北京时区(北京和上海处于同一时区) */
  public static final ZoneId BJ_ZONE = ZoneId.of(ZoneEnum.CTT.getName());

  /** 香港时区(香港和上海处于同一时区) */
  public static final ZoneId HK_ZONE = ZoneId.of(ZoneEnum.CTT.getName());

  /** 新加坡时区(新加坡和上海处于同一时区) */
  public static final ZoneId SG_ZONE = ZoneId.of(ZoneEnum.CTT.getName());

  /** 洛杉矶时区 */
  public static final ZoneId LA_ZONE = ZoneId.of(ZoneEnum.PST.getName());
}

class Format {
  public static class Date {
    /** 日期格式:YYYY-MM-DD 例如:2021-09-13 */
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    /** 日期格式:YYYY-M-D 例如:2021-9-13 */
    public static final String YYYY_M_D = "yyyy-M-d";

    /** 日期格式:YYYYMMDD 例如:20210913 */
    public static final String YYYY_MM_DD_SHORT = "yyyyMMdd";

    /** 日期格式:YYYY/MM/DD 例如:2021/09/13 */
    public static final String YYYY_MM_DD_EN = "yyyy/MM/dd";

    /** 日期格式:YYYY/M/D 例如:2021/9/13 */
    public static final String YYYY_M_D_EN = "yyyy/M/d";

    /** 日期格式:YYYY年MM月DD日 例如:2021年09月13日 */
    public static final String YYYY_MM_DD_CN = "yyyy年MM月dd日";

    /** 日期格式:YYYY年M月D日 例如:2021年9月13日 */
    public static final String YYYY_M_D_CN = "yyyy年M月d日";

    /** 日期格式:YYYY.MM.DD 例如:2021.09.13 */
    public static final String YYYY_MM_DD_POINT = "yyyy.MM.dd";

    /** 日期格式:YYYY.M.D 例如:2021.9.13 */
    public static final String YYYY_M_D_POINT = "yyyy.M.d";

    /** 日期格式:YY.MM.DD 例如:21/9/13 */
    public static final String YY_MM_DD_EN = "yy/MM/dd";

    /** 日期格式:YY/M/D 例如:21/9/13 */
    public static final String YY_M_D_EN = "yy/M/d";

    /** 日期格式:MM/DD/YY 例如:09/13/21 */
    public static final String MM_DD_YY_EN = "MM/dd/yy";

    /** 日期格式:M/D/YY 例如:9/13/21 */
    public static final String M_D_YY_EN = "M/d/yy";

    /** 日期格式:YYYY-MM-DD E 例如:2021-09-13 星期一 */
    public static final String YYYY_MM_DD_E = "yyyy-MM-dd E";

    /** 日期格式:YY 例如:21 */
    public static final String YY = "yy";

    /** 日期格式:YY年 例如:21年 */
    public static final String YY_CN = "yy年";

    /** 日期格式:YYYY 例如:2021 */
    public static final String YYYY = "yyyy";

    /** 日期格式:YYYY年 例如:2021年 */
    public static final String YYYY_CN = "yyyy年";

    /** 日期格式:YYYY-MM 例如:2021-09 */
    public static final String YYYY_MM = "yyyy-MM";

    /** 日期格式:YYYYMM 例如:202109 */
    public static final String YYYY_MM_SHORT = "yyyyMM";

    /** 日期格式:YYYY/MM 例如:2021/09 */
    public static final String YYYY_MM_EN = "yyyy/MM";

    /** 日期格式:YYYY年MM月 例如:2021年09月 */
    public static final String YYYY_MM_CN = "yyyy年MM月";

    /** 日期格式:YYYY年M月 例如:2021年9月 */
    public static final String YYYY_M_CN = "yyyy年M月";

    /** 日期格式:MM-DD 例如:09-13 */
    public static final String MM_DD = "MM-dd";

    /** 日期格式:MMDD 例如:0913 */
    public static final String MM_DD_SHORT = "MMdd";

    /** 日期格式:MM/DD 例如:09/13 */
    public static final String MM_DD_EN = "MM/dd";

    /** 日期格式:M/D 例如:9/13 */
    public static final String M_D_EN = "M/d";

    /** 日期格式:MM月DD日 例如:09月13日 */
    public static final String MM_DD_CN = "MM月dd日";

    /** 日期格式:M月D日 例如:9月13日 */
    public static final String M_D_CN = "M月d日";
  }

  public static class Time {
    /** 时间格式:HH:MM:SS 例如:23:08:45 */
    public static String HH_MM_SS = "HH:mm:ss";

    /** 时间格式:H:M:S 例如:23:8:45 */
    public static String H_M_S = "H:m:s";

    /** 时间格式:HHMMSS 例如:230845 */
    public static String HH_MM_SS_SHORT = "HHmmss";

    /** 时间格式:HH时MM分SS秒 例如:23时08分45秒 */
    public static String HH_MM_SS_CN = "HH时mm分ss秒";

    /** 时间格式:HH:MM 例如:23:08 */
    public static String HH_MM = "HH:mm";

    /** 时间格式:H:M 例如:23:8 */
    public static String H_M = "H:m";

    /** 时间格式:HH时MM分 例如:23时08分 */
    public static String HH_MM_CN = "HH时mm分";

    /** 时间格式:HH:MM 上午/下午 例如:11:08 下午 */
    public static String HH_MM_A = "hh:mm a";

    /** 时间格式:HH:MM:SS.SSS 例如:23:08:45.698 */
    public static String HH_MM_SS_SSS = "HH:mm:ss.SSS";
  }

  public static class DateTime {

    /** 时间格式:yyyy-MM-dd HH:mm:ss 例如:2021-09-13 23:08:45 */
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    /** 时间格式:yyyy-M-d H:m:s 例如:2021-9-13 23:8:45 */
    public static final String YYYY_M_D_H_M_S = "yyyy-M-d H:m:s";

    /** 时间格式:yyyyMMddHHmmss 例如:20210913230845 */
    public static final String YYYY_MM_DD_HH_MM_SS_SHORT = "yyyyMMddHHmmss";

    /** 时间格式:yyyy/MM/dd HH:mm:ss 例如:2021/09/13 23:08:45 */
    public static final String YYYY_MM_DD_HH_MM_SS_EN = "yyyy/MM/dd HH:mm:ss";

    /** 时间格式:yyyy/M/d H:m:s 例如:2021/9/13 23:8:45 */
    public static final String YYYY_M_D_H_M_S_EN = "yyyy/M/d H:m:s";

    /** 时间格式:yyyy年MM月dd日 HH:mm:ss 例如:2021年09月13日 23:08:45 */
    public static final String YYYY_MM_DD_CN_HH_MM_SS = "yyyy年MM月dd日 HH:mm:ss";

    /** 时间格式:yyyy年MM月dd日 HH时mm分ss秒 例如:2021年09月13日 23时08分45秒 */
    public static final String YYYY_MM_DD_HH_MM_SS_CN = "yyyy年MM月dd日 HH时mm分ss秒";

    /** 时间格式:yyyy-MM-dd HH:mm 例如:2021-09-13 23:08 */
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";

    /** 时间格式:yyyy-M-d H:m 例如:2021-9-13 23:8 */
    public static final String YYYY_M_D_H_M = "yyyy-M-d H:m";

    /** 时间格式:yyyyMMddHHmm 例如:202109132308 */
    public static final String YYYY_MM_DD_HH_MM_SHORT = "yyyyMMddHHmm";

    /** 时间格式:yyyy/MM/dd HH:mm 例如:2021/09/13 23:08 */
    public static final String YYYY_MM_DD_HH_MM_EN = "yyyy/MM/dd HH:mm";

    /** 时间格式:yyyy/M/d H:m 例如:2021/9/13 23:8 */
    public static final String YYYY_M_D_H_M_EN = "yyyy/M/d H:m";

    /** 时间格式:yyyy/M/d H:m 上午/下午 例如:2021/9/13 11:8 下午 */
    public static final String YYYY_M_D_H_M_A_EN = "yyyy/M/d h:m a";

    /** 时间格式:MM-dd HH:mm 例如:09-13 23:08 */
    public static final String MM_DD_HH_MM = "MM-dd HH:mm";

    /** 时间格式:MM月dd日 HH:mm 例如:09月13日 23:08 */
    public static final String MM_DD_CN_HH_MM = "MM月dd日 HH:mm";

    /** 时间格式:MM月dd日 HH时mm分 例如:09月13日 23时08分 */
    public static final String MM_DD_HH_MM_CN = "MM月dd日 HH时mm分";

    /** 时间格式:MM-dd HH:mm:ss 例如:09-13 23:08:45 */
    public static final String MM_DD_HH_MM_SS = "MM-dd HH:mm:ss";

    /** 时间格式:MM月dd日 HH:mm:ss 例如:09月13日 23:08:45 */
    public static final String MM_DD_CN_HH_MM_SS = "MM月dd日 HH:mm:ss";

    /** 时间格式:MM月dd日 HH时mm分ss秒 例如:09月13日 23时08分45秒 */
    public static final String MM_DD_HH_MM_SS_CN = "MM月dd日 HH时mm分ss秒";

    /** 时间格式:yyyy年MM月dd日 HH:mm:ss 上午/下午 例如:2021年09月13日 11:08:45 下午 */
    public static final String YYYY_MM_DD_CN_HH_MM_SS_A = "yyyy年MM月dd日 hh:mm:ss a";

    /** 时间格式:yyyy年MM月dd日 HH时mm分ss秒 上午/下午 例如:2021年09月13日 11时08分45秒 下午 */
    public static final String YYYY_MM_DD_HH_MM_SS_A_CN = "yyyy年MM月dd日 hh时mm分ss秒 a";

    /** 时间格式:yyyy-MM-dd HH:mm:ss.sss 例如:2021-09-13 23:08:45.698 */
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";

    /** 时间格式:yyyyMMddHHmmssSSS 例如:20210913230845698 */
    public static final String YYYY_MM_DD_HH_MM_SS_SSS_SHORT = "yyyyMMddHHmmssSSS";

    /** 时间格式:yyyy-M-d H:m:s.SSS 例如:2021-9-13 23:8:45.698 */
    public static final String YYYY_M_D_H_M_S_SSS = "yyyy-M-d H:m:s.SSS";

    /** 时间格式:yyyy/M/d H:m:s.SSS 例如:2021/9/13 23:8:45.698 */
    public static final String YYYY_M_D_H_M_S_SSS_EN = "yyyy/M/d H:m:s.SSS";

    /** 时间格式:EEE MMM dd HH:mm:ss zzz yyyy 例如:星期一 九月 13 23:08:45 CT 2021 */
    public static final String EEE_MMM_DD_HH_MM_SS_ZZZ_YYYY = "EEE MMM dd HH:mm:ss zzz yyyy";
  }
}
