package online.inote.naruto.utils.http;

import okhttp3.MediaType;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @description Http请求任务
 * @author gaopengsui@creditease.cn
 * @date 2021/10/08 4:19 下午
 */
public abstract class Request {

  public static final MediaType APPLICATION_JSON =
      MediaType.parse("application/json; charset=utf-8");

  public static final MediaType APPLICATION_FORM_URLENCODED =
      MediaType.parse("application/x-www-form-urlencoded; charset=utf-8");

  protected String baseUrl;
  protected String url;
  protected String targetUrl;
  protected Object requestBody;
  protected Map<String, Object> headerParamMap = new HashMap<>();
  protected Map<String, Object> urlParamMap = new HashMap<>();
  protected Map<String, Object> requestBodyMap = new HashMap<>();
  protected Map<String, Object> formParamMap = new HashMap<>();
  protected Object formBody;
  protected MediaType mediaType = APPLICATION_JSON;

  /**
   * GET请求
   *
   * @return
   * @throws IOException
   */
  public abstract Result get();

  /**
   * POST请求
   *
   * @return
   */
  public abstract Result post();

  /**
   * POST表单请求
   *
   * @return
   */
  public abstract Result postForm();

  /**
   * PUT请求
   *
   * @return
   */
  public abstract Result put();

  /**
   * DELETE请求
   *
   * @return
   */
  public abstract Result delete();

  public Request setRequestBody(Object params) {
    this.requestBody = params;
    return this;
  }

  public Request setRequestBody(String key, Object val) {
    this.requestBodyMap.put(key, val);
    return this;
  }

  public Request setFormBody(Object params) {
    this.formBody = params;
    return this;
  }

  public Request setFormParamMap(String key, Object val) {
    this.formParamMap.put(key, val);
    return this;
  }

  public Request setHeaderParam(String key, String val) {
    this.headerParamMap.put(key, val);
    return this;
  }

  public Request setHeaderParam(Map<String, Object> headerParamMap) {
    this.headerParamMap.putAll(headerParamMap);
    return this;
  }

  public Request setUrlParam(String key, String val) {
    this.urlParamMap.put(key, val);
    return this;
  }

  public Request setUrlParam(Map<String, Object> headerParamMap) {
    this.urlParamMap.putAll(headerParamMap);
    return this;
  }

  public Request setMediaType(MediaType mediaType) {
    this.mediaType = mediaType;
    return this;
  }

  public Request setBaseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
    this.targetUrl = this.baseUrl + this.url;
    return this;
  }

  public Request setUrl(String url) {
    this.url = url;
    this.targetUrl = this.baseUrl + this.url;
    return this;
  }

  public Request setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }
}
