package online.inote.naruto.utils.log;

/**
 * @description Debug Logger
 * @author gaopengsui@creditease.cn
 * @date 2021/10/26 10:45 下午
 */
public class DebugLogger extends Logger {

  protected DebugLogger(org.slf4j.Logger logger, String module) {
    super(logger, module);
  }

  /**
   * 输出
   *
   * @param message 消息
   */
  @Override
  protected void print(String message) {
    if (this.getLogger().isDebugEnabled()) {
      this.getLogger().debug(message);
    }
  }

  /**
   * 输出
   *
   * @param message 消息
   * @param throwable 异常
   */
  @Override
  protected void print(String message, Throwable throwable) {
    if (this.getLogger().isDebugEnabled()) {
      this.getLogger().debug(message, throwable);
    }
  }
}
