package online.inote.naruto.utils.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;

import java.io.Serializable;

/**
 * @description 响应信息
 * @author gaopengsui@creditease.cn
 * @date 2021/09/08 11:24
 */
@Getter
@FieldNameConstants
@AllArgsConstructor
@NoArgsConstructor
public class Response<T> implements Serializable {

  private static final long serialVersionUID = 1940009865956053614L;

  private String code;
  private String message;
  private T data;

  public Response(String code, String message) {
    this.code = code;
    this.message = message;
  }

  public static <T> Response<T> create(String code, String message) {
    return new Response<>(code, message);
  }

  public static <T> Response<T> create(String code, String message, T data) {
    return new Response<>(code, message, data);
  }

  public static <T> Response<T> create(CodeMessage codeMessage, T data) {
    return new Response<>(codeMessage.getCode(), codeMessage.getMessage(), data);
  }

  public static <T> Response<T> success(T data) {
    return Response.create(
        CommonCodeMessage.SUCCESS.getCode(), CommonCodeMessage.SUCCESS.getMessage(), data);
  }

  public static <T> Response<T> fail() {
    return Response.create(CommonCodeMessage.FAIL.getCode(), CommonCodeMessage.FAIL.getMessage());
  }

  public static <T> Response<T> fail(String message) {
    return Response.create(CommonCodeMessage.FAIL.getCode(), message);
  }

  public boolean isSuccess() {
    return CommonCodeMessage.SUCCESS.getCode().equals(this.code);
  }
}
